package com.mx.dla.dda.admin.catalogos.transacciones.actions;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.transacciones.bos.TransaccionesBO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.EstudiosTransDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ReporteGeneralDTO;
import com.mx.dla.global.actions.BaseAction;

import lombok.Data;

@Data
public class ReporteGeneralAction extends BaseAction  {
	
	private List<EstudiosTransDTO> estudiosTrans;
	private List<ReporteGeneralDTO> reporteGeneral;
	private String estudio;
	private String fecha;
	private String fileName;
	private InputStream fileInputStream;
	private String mes;
	private String anio;
	
	@Autowired
	private TransaccionesBO transacciones;
	
	@Override
	public String execute() throws Exception {
		setPmns();
		setEstudiosTrans(transacciones.getEstudiosTrans());
		return SUCCESS;
	}
	
	public void setPmns() {
		logger.debug("pmn : " + this.getPmn() + "pmnReturn : " + this.getPmnReturn());
		this.getSession().put("pmn", 215);
		this.getSession().put("pmnReturn", 215);
		this.setPmn("215");
		this.setPmnReturn("215");
	}
	
	public String generarReporte() throws Exception {
		System.out.println("Datos para reporte Fecha: " + fecha + " Estudio: " + estudio);
		String [] date = fecha.split("/");
		setReporteGeneral(transacciones.reporteGeneral(date[0],date[1],estudio));
		setPmns();
		System.out.println("Recuperando reporte: " + getReporteGeneral().size());
		return SUCCESS;
	}
	
	public String generarExcel() throws Exception {
		System.out.println("Datos para reporte Fecha: " + fecha + " Estudio: " + estudio);
		String [] date = fecha.split("/");
		setFileInputStream(transacciones.obtenerReporteEnExcel(date[0],date[1],estudio));
		setFileName(date[0] + "-" + date[1] + "-01");
		setPmns();
		return SUCCESS;
	}
	
	public String cerrarReporte(){
		transacciones.cerrarRporte(getfecha());
		return SUCCESS;
	}
	
	public String reabrirReporte(){
		transacciones.reabrirReporte(mes, anio);
		return SUCCESS;
	}
	
	public String getfecha() {
		Integer year = Calendar.getInstance().get(Calendar.YEAR);
		Integer month = Calendar.getInstance().get(Calendar.MONTH);
		if(month == 0) {
			year = year -1;
			month = 12;
		}
		setMes(StringUtils.leftPad(month.toString(), 2));
		setAnio(year.toString());
		return year.toString() + "-" + month.toString()  + "-" +  "01";
	}

}
