package com.mx.dla.dda.carga.transaccion.actions;

import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.carga.transaccion.bos.CargaTransaccionesBO;
import com.mx.dla.dda.carga.transaccion.dtos.RowReporteCargaDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.listado.dtos.ContentType;

public class DescargaArchivoVistaPreviaAction extends BaseContratoAction {

	String algo;
	private static final long serialVersionUID = 281552368437405368L;
	private String error;
	
	private List<RowReporteCargaDTO> vistaPrevia;
	
	@Autowired
	private CargaTransaccionesBO cargaTransaccionesBO;
	
	public String descargaArchivoVistaPrevia(){
       logger.info("se : [{}]", error);
       logger.info(algo);
		String nombre;
		byte[] vistaPreviac;
					
		
		try {
			
			vistaPreviac = cargaTransaccionesBO.descargaArchivoVistaPrevia(vistaPrevia);
			
			System.out.println("algo..."+vistaPrevia);
			
			nombre = "reporteVistaPreviaCargaTransacciones";
					
			HttpServletResponse response = ServletActionContext.getResponse();
			response.setContentLength(vistaPreviac.length);
			response.setContentType(ContentType.EXCELX.name());
			response.setHeader("Content-Disposition","attachment;filename="+nombre+".xlsx");		    
					    
			ServletOutputStream out = response.getOutputStream();
			out.write(vistaPreviac);
			out.flush();
			out.close();
	
			
		} catch (Exception e) {
			
			error = e.getMessage();
		}
		
		return SUCCESS;

		
	}
	
	public void setError(String error) {
		this.error = error;
	}
	public String getError() {
		return error;
	}

	public void setVistaPrevia(List<RowReporteCargaDTO> vistaPrevia) {
		this.vistaPrevia = vistaPrevia;
	}
	 
	public List<RowReporteCargaDTO> getVistaPrevia() {
		return vistaPrevia;
	}


}
