package com.mx.dla.dda.catalogos.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.catalogos.bos.CatalogosBO;
import com.mx.dla.dda.catalogos.dtos.CategoriaDTO;
import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.catalogos.dtos.MedioEntregaDTO;
import com.mx.dla.dda.catalogos.dtos.ServicioDTO;
import com.mx.dla.dda.catalogos.dtos.TerritorioDTO;
import com.mx.dla.global.actions.BaseAction;

@Controller
@Scope("request")
public class CatalogosAction extends BaseAction {

	private static final long serialVersionUID = 1L;

	private String tipoOperacion;
	private int idContrato;
	
	private List<EstudioDTO> estudios;
	private List<CategoriaDTO> categorias;
	private List<ServicioDTO> servicios;
	private List<TerritorioDTO> territorios;
	private List<MedioEntregaDTO> mediosEntrega;
	

	@Autowired
	private CatalogosBO catalogosBO;

	@Override
	public String execute() throws Exception {
		return SUCCESS;
	}

	public String metodo() {
		setIdContrato(catalogosBO.obtenSqIdContrato(tipoOperacion, idContrato));
		setEstudios(catalogosBO.obtenListaEstudios());
		setCategorias(catalogosBO.obtenListaCategorias());
		setServicios(catalogosBO.obtenListaServicios());
		setTerritorios(catalogosBO.obtenListaTerritorios());
		setMediosEntrega(catalogosBO.obtenListaMediosEntrega());
		return "OK";
	}

	public String getTipoOperacion() {
		return tipoOperacion;
	}

	public void setTipoOperacion(String tipoOperacion) {
		this.tipoOperacion = tipoOperacion;
	}

	public CatalogosBO getGeneralesBO() {
		return catalogosBO;
	}

	public void setGeneralesBO(CatalogosBO catalogosBO) {
		this.catalogosBO = catalogosBO;
	}

	public List<EstudioDTO> getEstudios() {
		return estudios;
	}

	public void setEstudios(List<EstudioDTO> estudios) {
		this.estudios = estudios;
	}

	public List<CategoriaDTO> getCategorias() {
		return categorias;
	}

	public void setCategorias(List<CategoriaDTO> categorias) {
		this.categorias = categorias;
	}

	public List<ServicioDTO> getServicios() {
		return servicios;
	}

	public void setServicios(List<ServicioDTO> servicios) {
		this.servicios = servicios;
	}

	public List<TerritorioDTO> getTerritorios() {
		return territorios;
	}

	public void setTerritorios(List<TerritorioDTO> territorios) {
		this.territorios = territorios;
	}

	public List<MedioEntregaDTO> getMediosEntrega() {
		return mediosEntrega;
	}

	public void setMediosEntrega(List<MedioEntregaDTO> mediosEntrega) {
		this.mediosEntrega = mediosEntrega;
	}

	public int getIdContrato() {
		return idContrato;
	}

	public void setIdContrato(int idContrato) {
		this.idContrato = idContrato;
	}

}
