package com.mx.dla.dda.contrato.bdeal.actions;

import java.io.File;
import java.io.IOException;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.bdeal.bos.BdealBO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.ws.actualizaridbroadview.ResponseActualizaIdBVDTO;

public class SubirDocumentoBdealAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private Long idContrato;
	private File fileUpload;
	private String fileUploadContentType;
	private String fileUploadFileName;
	private String error;
	private int titulosLeidos;
	private int titulosActualizados;
	private int titulosConError;
	private long idCarga;
	private boolean exito;
	private String mensaje;
	
	@Autowired
	private BdealBO bdealBO;

	@Override
	public String execute() throws Exception {
		
		UsuarioDTO usuario = null;
		ResponseActualizaIdBVDTO response = null;
		
		try {
			
			usuario = (UsuarioDTO) getSession().get("usuario");
			response = bdealBO.guardaDocumento(fileUpload, fileUploadFileName, idContrato, usuario.getExpediente());
			
			setExito(response.getResultado());
			setMensaje(response.getMensaje());
			
			if(response.getResultado()){	
				setTitulosConError(Integer.parseInt(response.getDatosCarga().getTOTAL_ERROR()));
				setTitulosLeidos(Integer.parseInt(response.getDatosCarga().getTOTAL_REGISTROS()));
				setTitulosActualizados(Integer.parseInt(response.getDatosCarga().getTOTAL_CARGADOS()));
				setIdCarga(Long.parseLong(response.getDatosCarga().getID_CARGA()));
			}
			
		}catch(IOException ex) {
			logger.error("Error al subir documento [{}]", ex);
			error = "Error al subir documento.";
		}
		
		return SUCCESS;
	}

	public Long getIdContrato() {
		return idContrato;
	}

	public void setIdContrato(Long idContrato) {
		this.idContrato = idContrato;
	}

	public File getFileUpload() {
		return fileUpload;
	}

	public void setFileUpload(File fileUpload) {
		this.fileUpload = fileUpload;
	}

	public String getFileUploadContentType() {
		return fileUploadContentType;
	}

	public void setFileUploadContentType(String fileUploadContentType) {
		this.fileUploadContentType = fileUploadContentType;
	}

	public String getFileUploadFileName() {
		return fileUploadFileName;
	}

	public void setFileUploadFileName(String fileUploadFileName) {
		this.fileUploadFileName = fileUploadFileName;
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}

	public int getTitulosLeidos() {
		return titulosLeidos;
	}

	public void setTitulosLeidos(int titulosLeidos) {
		this.titulosLeidos = titulosLeidos;
	}

	public int getTitulosActualizados() {
		return titulosActualizados;
	}

	public void setTitulosActualizados(int titulosActualizados) {
		this.titulosActualizados = titulosActualizados;
	}

	public int getTitulosConError() {
		return titulosConError;
	}

	public void setTitulosConError(int titulosConError) {
		this.titulosConError = titulosConError;
	}
	
	public void setIdCarga(long idCarga) {
		this.idCarga = idCarga;
	}
	
	public long getIdCarga() {
		return idCarga;
	}
	
	public void setExito(boolean exito) {
		this.exito = exito;
	}
	
	public boolean getExito() {
		return exito;
	}
	
	public void setMensaje(String mensaje) {
		this.mensaje = mensaje;
	}
	
	public String getMensaje() {
		return mensaje;
	}
	
}
