package com.mx.dla.dda.contrato.listado.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.ibatis.exceptions.PersistenceException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.catalogos.bos.CatalogosBO;
import com.mx.dla.dda.contrato.listado.bos.ListadoContratoBO;
import com.mx.dla.dda.contrato.listado.dtos.CatListadoContratoDTO;
import com.mx.dla.dda.contrato.listado.dtos.ContratoListaDTO;
import com.mx.dla.dda.contrato.listado.dtos.RequestListadoDTO;
import com.mx.dla.global.actions.BaseAction;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionContext;

import lombok.Data;

public class ListadoAction extends BaseAction {

	private static final long serialVersionUID = 1L;

	private CatListadoContratoDTO catalogos = new CatListadoContratoDTO();
	private List<ContratoListaDTO> listado  = new ArrayList<>();
	private String  request;
	private String  msgError;
	private String  msgExito;
	private HttpServletRequest httpRequest;
	
	private static final String ID_CONTRATO = "idContrato";
	private static final String ID_MOVIMIENTO = "idMovimiento";
	private static final String TIPO_CONTRATO = "tipoContrato";
	private static final String ERROR_MESSAGE_1 = "Ocurri un error al obtener los datos.";
	private static final String ERROR_MESSAGE_2 = "Ocurri un error al realizar la operacin.";
		
	@Autowired
	private ListadoContratoBO listadoContratoBO;
	
	@Autowired
	private CatalogosBO catalogosBO;
	
	public String execute() {
		RequestListadoDTO requestListadoDTO = null;		
		ObjectMapper mapper = new ObjectMapper();
		
		try {			
			
			logger.debug("Inicia obtencion listado. "+request);			
			requestListadoDTO = mapper.readValue(request, RequestListadoDTO.class);			
			listado = listadoContratoBO.getListadoContratos(requestListadoDTO);
			logger.debug("Fin obtencion listado");										
			
		} catch (JsonParseException | JsonGenerationException |  JsonMappingException je) {
			   this.msgError = ERROR_MESSAGE_1;
			   logger.error("Error.", je);			 			
		} catch (IOException ioe) {
			   this.msgError = ERROR_MESSAGE_1;
			   logger.error("Error.", ioe);			   			
		}catch(PersistenceException  ibe){
			   this.msgError = ERROR_MESSAGE_1;
			   logger.error("Error.", ibe);			   			   
		}catch(Exception e){
			   this.msgError = ERROR_MESSAGE_1;
			   logger.error("Error.", e);			   
		}				
		return Action.SUCCESS;
	}

	public String obtenerDocumentosCto() {
		RequestListadoDTO requestListadoDTO = null;		
		ObjectMapper mapper = new ObjectMapper();
		
		try {			
			
			requestListadoDTO = mapper.readValue(request, RequestListadoDTO.class);
			logger.debug(requestListadoDTO.toString());
			listado = listadoContratoBO.getDocumentos(requestListadoDTO.getIdContrato());
														
		} catch (JsonParseException | JsonGenerationException |  JsonMappingException je) {
			   this.msgError = ERROR_MESSAGE_1;
			   logger.error("Error.", je);			 			
		} catch (IOException ioe) {
			   this.msgError = ERROR_MESSAGE_1;
			   logger.error("Error.", ioe);			   			
		}catch(PersistenceException  ibe){
			   this.msgError = ERROR_MESSAGE_1;
			   logger.error("Error.", ibe);			   			   
		}catch(Exception e){
			   this.msgError = ERROR_MESSAGE_1;
			   logger.error("Error.", e);			   
		}				
		return Action.SUCCESS;
	}
	
	//jun-17 crea enmienda o adendum para cualqueir seccion...
	public String agregarEnmOAden(){
		
		try {
						 			
			Integer operacion = Integer.parseInt(httpRequest.getParameter(ID_MOVIMIENTO));
												
			this.getSession().put("pmn"         , httpRequest.getParameter("pmn"));																
			this.getSession().put(TIPO_CONTRATO, Long.parseLong(httpRequest.getParameter(TIPO_CONTRATO)));
			
			if( operacion.intValue() == 1)
			{
				ActionContext.getContext().getSession().put(ID_CONTRATO, null);											
				msgExito = "OK";
			}				
			else if( operacion.intValue() == 2 )
			{				 
				createAdemum();
			}
			else if( operacion.intValue() == 3 || operacion.intValue() == 4)
			{				 
				HashMap<String, Object> params = new HashMap<>();								
				params.put(TIPO_CONTRATO, Integer.parseInt(httpRequest.getParameter(TIPO_CONTRATO)));
				params.put(ID_MOVIMIENTO,                  httpRequest.getParameter(ID_MOVIMIENTO));				
				params.put(ID_CONTRATO,   Long.parseLong(  httpRequest.getParameter(ID_CONTRATO)));
			
				Long idNuevo = listadoContratoBO.crearEmnienda(params);								
				this.getSession().put(ID_CONTRATO, idNuevo);							
				
				msgExito = String.valueOf(idNuevo);
				logger.info("Enmienda generado con el id:"+ (Long)this.getSession().get(ID_CONTRATO) );
			}
			else if( operacion.intValue() == 5 )
			{				 
				createAdemum();
			}
		    
		}catch(PersistenceException  ibe){
			   this.msgError = ERROR_MESSAGE_2;
			   logger.error("Error.", ibe);
			   return Action.ERROR;
		}catch(Exception e){
			   this.msgError = ERROR_MESSAGE_2;
			   logger.error("Error.", e);
			   return Action.ERROR;
		}		
		return Action.SUCCESS;
	}
	
	private void createAdemum() {
		HashMap<String, Object> params = new HashMap<>();								
		params.put(ID_CONTRATO,   Long.parseLong(  httpRequest.getParameter(ID_CONTRATO)));
		params.put(ID_MOVIMIENTO,                  httpRequest.getParameter(ID_MOVIMIENTO));	
		Long idNuevo = listadoContratoBO.crearAdendum(params);								
		this.getSession().put(ID_CONTRATO, idNuevo);							
		
		msgExito = String.valueOf(idNuevo);
		logger.info("Adendum generado con el id:"+ (Long)this.getSession().get(ID_CONTRATO) );
	}
	
	public String verContrato(){
		
		try {						
			this.getSession().put("pmn"         , httpRequest.getParameter("pmn"));																
			this.getSession().put(TIPO_CONTRATO, Long.parseLong(httpRequest.getParameter(TIPO_CONTRATO)));			
			this.getSession().put(ID_CONTRATO  , Long.parseLong(httpRequest.getParameter(ID_CONTRATO)));			
			this.getSession().put("numContrato" , httpRequest.getParameter("numContrato"));
			this.getSession().put("estudio"     , httpRequest.getParameter("estudio"));		
			logger.info("Se redirecciona hacia el contrato:"+this.getSession().get(ID_CONTRATO));
		}catch(PersistenceException  ibe){
			   this.msgError = ERROR_MESSAGE_2;
			   logger.error("Error.", ibe);
			   return Action.ERROR;
		}catch(Exception e){
			   this.msgError = ERROR_MESSAGE_2;
			   logger.error("Error.", e);
			   return Action.ERROR;
		}		
		
		return Action.SUCCESS;
	}
	
	public String getCatalogosAction() {
		
		try {
						
			catalogos.setEstudios(catalogosBO.obtenListaEstudios());
									
		}catch(PersistenceException  ibe){
			   this.msgError = ERROR_MESSAGE_1;
			   logger.error("Error.", ibe);				   			   
		}catch(Exception e){
			   this.msgError = ERROR_MESSAGE_1;
			   logger.error("Error.", e);				   
		}		
		return Action.SUCCESS;
	}		
	
	public List<ContratoListaDTO> getListado() {
		return listado;
	}

	public void setListado(List<ContratoListaDTO> listado) {
		this.listado = listado;
	}

	public String getRequest() {
		return request;
	}

	public void setRequest(String request) {
		this.request = request;
	}
	
	public void setMsgError(String msgError) {
		this.msgError = msgError;
	}

	public String getMsgError() {
		return msgError;
	}		
		
	public CatListadoContratoDTO getCatalogos() {
		return this.catalogos;
	}

	public void setCatalogos(CatListadoContratoDTO catalogos) {
		this.catalogos = catalogos;
	}
		
	public String getMsgExito() {
		return msgExito;
	}

	@Override
	public void setServletRequest(HttpServletRequest request) {
           this.httpRequest = request;		
	}
	
}

