package com.mx.dla.dda.contrato.minimoseleccion.actions;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.minimoseleccion.bos.MinimoSeleccionBO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.AnnioPeriodoDTO;


@Controller
@Scope("request")
public class AnniosPeriodosAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private AnnioPeriodoDTO annioPeriodo;

	private Long idContrato;
	private String tipoPago;
	private Long idContratoPago;
	private Integer annio;
	
	@Autowired
	MinimoSeleccionBO minimoSeleccionBO;

	public String execute() {
		
		setAnnioPeriodo(minimoSeleccionBO.obtenAnnioPeriodo(idContratoPago, annio, tipoPago, idContrato));

		return SUCCESS;
	}

	public AnnioPeriodoDTO getAnnioPeriodo() {
		return annioPeriodo;
	}

	public void setAnnioPeriodo(AnnioPeriodoDTO annioPeriodo) {
		this.annioPeriodo = annioPeriodo;
	}

	public Long getIdContrato() {
		return idContrato;
	}

	public void setIdContrato(Long idContrato) {
		this.idContrato = idContrato;
	}

	public String getTipoPago() {
		return tipoPago;
	}

	public void setTipoPago(String tipoPago) {
		this.tipoPago = tipoPago;
	}

	public Long getIdContratoPago() {
		return idContratoPago;
	}

	public void setIdContratoPago(Long idContratoPago) {
		this.idContratoPago = idContratoPago;
	}

	public Integer getAnnio() {
		return annio;
	}

	public void setAnnio(Integer annio) {
		this.annio = annio;
	}

}
