package com.mx.dla.dda.contrato.minimoseleccion.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.bos.JustificacionBO;
import com.mx.dla.dda.contrato.minimoseleccion.bos.MinimoSeleccionBO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.CategoriaMinimoDTO;

@Controller
@Scope("request")
public class CambioMinimoAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private List<CategoriaMinimoDTO> campoPeriodos;
	
	private Long idContrato;
	
	private String justificacion;
	
	@Autowired
	private MinimoSeleccionBO minimoSeleccionBO;
	
	@Autowired
	private JustificacionBO justificacionBO;
	
	@Override
	public String execute() {
		
		logger.debug("In execute of CambioMinimoAction");
		minimoSeleccionBO.cambiaMinimoCategoria(campoPeriodos);
		getSession().put("idContrato", getIdContrato());
		
		if(justificacion != null){
			UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
			justificacionBO.insertarJustificacion(justificacion, idContrato, usuario);
		}
		
		return SUCCESS;
	}

	public void setCampoPeriodos(List<CategoriaMinimoDTO> campoPeriodos) {
		this.campoPeriodos = campoPeriodos;
	}

	public List<CategoriaMinimoDTO> getCampoPeriodos() {
		return campoPeriodos;
	}
	
	public void setIdContrato(Long idContrato) {
		this.idContrato = idContrato;
	}
	
	public Long getIdContrato() {
		return idContrato;
	}

	public String getJustificacion() {
		return justificacion;
	}

	public void setJustificacion(String justificacion) {
		this.justificacion = justificacion;
	}

}
