package com.mx.dla.dda.contrato.transaccion.minimoGarantizado.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.minimoGarantizado.bos.MinimoGarantizadoBO;
import com.mx.dla.dda.contrato.transaccion.minimoGarantizado.dtos.MinGarantizadoDTO;
//import com.mx.dla.global.actions.BaseAction;


public class MinimoGarantizadoAction extends BaseContratoAction {

	private static final long serialVersionUID = 21363082260499407L;

	private List<MinGarantizadoDTO> minimoGarantizado;
	
	private String mensajeExcepcion;
	
	@Autowired
	private MinimoGarantizadoBO minimoGarantizadoBO;
	
	public String primeraCarga(){
		return SUCCESS;
	}

	public String consultaInformacion() 
	{

		try {
				Long idContrato = (Long) this.getSession().get("idContrato");
				minimoGarantizado = minimoGarantizadoBO.consultaInformacionMinimos( idContrato );
				logger.debug("minimoGarantizado [{}] : " + minimoGarantizado );
				
			} catch (Exception e) {
				logger.debug("Exception : [{}]", e);
				setMensajeExcepcion("Fallo la consulta de informacin.");
			}

		return SUCCESS;
	}

	public List<MinGarantizadoDTO> getMinimoGarantizado() 
	{
		return minimoGarantizado;
	}

	public void setMinimoGarantizado(List<MinGarantizadoDTO> minimoGarantizado) 
	{
		this.minimoGarantizado = minimoGarantizado;
	}

	public void setMensajeExcepcion(String mensajeExcepcion) 
	{
		this.mensajeExcepcion = mensajeExcepcion;
	}
	
	public String getMensajeExcepcion() 
	{
		return mensajeExcepcion;
	}

}
