package com.mx.dla.dda.reporte.amortizacion.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.reporte.amortizacion.bos.ReporteExcelAmortizacionBO;

public class ExcelAmortizacionAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private String fecha;

	private Long idEstudio;

	private InputStream fileInputStream;

	@Autowired
	ReporteExcelAmortizacionBO reporteExcelAmortizacionBO;

	@Override
	public String execute() {
		return SUCCESS;
	}

	public String descargarArchivo() {

		try {
			byte[] bytes = reporteExcelAmortizacionBO.generaReporteAmortizacion(idEstudio, fecha);
			fileInputStream = new ByteArrayInputStream(bytes);
		} catch (Exception e) {
			logger.error("Error : ", e);
		}

		return SUCCESS;
	}

	public String descargarArchivoSAP() {

		try {
			byte[] bytes = reporteExcelAmortizacionBO.generaReporteAmortizacionSAP(idEstudio, fecha);
			fileInputStream = new ByteArrayInputStream(bytes);
		} catch (Exception e) {
			logger.error("Error : ", e);
		}

		return SUCCESS;
	}
	
	public String descargarArchivoSAPDLA() {

		try {
			byte[] bytes = reporteExcelAmortizacionBO.generaReporteAmortizacionSAPDLA(idEstudio, fecha);
			fileInputStream = new ByteArrayInputStream(bytes);
		} catch (Exception e) {
			logger.error("Error : ", e);
		}

		return SUCCESS;
	}

	public String getFecha() {
		return fecha;
	}

	public void setFecha(String fecha) {
		this.fecha = fecha;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

}
