package com.mx.dla.dda.reporte.pago.actions;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.addons.bos.ReporteAddOnsBO;
import com.mx.dla.dda.carga.transaccion.bos.CargaTransaccionesBO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.reporte.movimientos.bos.ReporteMovimientosBO;
import com.mx.dla.dda.reporte.pago.bos.ReporteContingenciaBO;

import lombok.Data;

@Data
public class ReporteSuscriptoresExcelAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;
	private InputStream fileInputStream;
	private String fileName;
	private String idCon;
	private String idEstudio;
	private String fechaInicio;

	@Autowired
	private ReporteAddOnsBO reporteMovimientos;
	
	public String execute() {
		
		fileInputStream = reporteMovimientos.obtenerReporteEnExcel(idEstudio,fechaInicio);
		setFileName(reporteMovimientos.obtenerNombreEstudio(idEstudio)+"_"+fechaInicio.replace("/",""));
		return SUCCESS;
	}


}
