/**********************************************************************************
 *
 *  ROGUE SELECT COMPONENT
 *
 *********************************************************************************/
(function ( $ ) {

    $.select = function(element, options) {

        var defaults = {
            id : null,
            name : null,
            content : null,
            trans : null,

            url : null,
            selected : null,

            fields : {
                value  : 'value',
                text : 'text'
            },
            
            displayZero : false,
            root : null,
            async : true,
            postData : {}

        };

        var s = this;
        var element = element;

        s.settings = {};

        //CONSTRUCTOR
        s.init = function() {
            s.settings = $.extend({}, defaults, options);
            s.settings.id = (typeof element.attr('id') != 'undefined')? '#'+element.attr('id') : '.'+element.attr('class');
            s.settings.name = (typeof element.attr('id') != 'undefined')? element.attr('id') : element.attr('class');
            
            if(s.settings.content != null){
                _build();
            }else if(s.settings.url != null){
            	_invoke();
            }

        };

        //PUBLIC METHODS
        s.getValue = function(){
            return element.val();
        };

        s.getSelectedText = function(){
            return $(s.settings.id+' option:selected').html();
        };

        s.selectItem = function(id){
            element.val(id);
        };
        
        s.refresh = function(){
        	if(s.settings.url != null){
        		_invoke();
        	}
        };
        
        s.rebuild = function(data){
        	if(data != null){
        		s.settings.content = data;
                _build();
        	}
        };

        
        var _invoke = function(){
        	 $.ajax({
                 url : s.settings.url,
                 type : 'post',
                 dataType : 'json',
                 async : s.settings.async,
                 data : s.settings.postData,
                 success : function(data){
                 	s.settings.content = (s.settings.root != null)? data[s.settings.root] : data ;
                     if(data.error == null){
                         _build();
                     }
                 },
                 'error' : function(jqXHR,textStatus,errorThrown){
                     console.log('.:Rogue select error : ' + textStatus);
                 }
             });
        } ;
        
        //PRIVATE METHODS
        var _build = function(){
            var sContent = "";
            element.attr('data-type', 'select');
            if(s.settings.selected == null && !s.settings.displayZero){
                sContent += '<option value="">Seleccione</option>';
            }
            
            var selectedValue = (s.settings.selected != null)? s.settings.selected : 0 ;
            
            s.settings.content.forEach(function(item, i){
                if(s.settings.displayZero || item[s.settings.fields.value] != 0){
                	
                	var text = "";
                	
                	if(s.settings.trans != null){
                		text = window[s.settings.trans][item[s.settings.fields.text]]; 
                	}else{
                		text = item[s.settings.fields.text];
                	}
                	
                    if(selectedValue == item[s.settings.fields.value]){
                        sContent += '<option selected value="'+item[s.settings.fields.value]+'">'+text+'</option>';
                    }else{
                        sContent += '<option value="'+item[s.settings.fields.value]+'">'+text+'</option>';
                    }
                    
                }
            });
            element.html(sContent);
        };

        s.init();
        window[s.settings.name] = s;

        return s;
    };

    $.fn.select = function(options) {
        return new $.select(this, options);
    };

}( jQuery ));

