$(document).ready(function(){
	    inicializarBotones();
		cargarApartados("todos");	
});

function inicializarBotones(){
	$("#buscar").click(function()   
	{					
		cargarApartados($("#selectTipoAmortizable").val());	
	});
	
	$("#btNuevoApartado").click(function()   
	{		     	  			
		var menu = $("#pmn").val();
		var menuRegreso = $("#pmnReturn").val();	
		window.location.href = contextPath + '/catalogos/bolsas/altaApartado.action?pmn='+menu+'&pmnReturn='+menuRegreso+ '&idApartado=' + null;
		//window.location.href = contextPath + '/catalogos/bolsas/altaApartado.action?pmn=44' + '&idApartado=' + null;
	});		
}

function cargarApartados(operacion){	
	$.post( contextPath + '/catalogos/bolsas/indexCatalogoApartados.action', {amortizable : operacion})		
	.done(function( response ) 
	{		
		if(response.mensaje != null)	
			showError("Error al procesar la operaci\u00F3n.");			      
		else
		{			
			limpiarTabla();
		    crearTablaApartados(response.apartados);
		    $("table thead tr").addClass("encabezado");
		}				   			       		   
	});	
}

function crearTablaApartados(datos){	
	var data = [];		
	for(var i=0; i<datos.length; i++)
	{
		var raw = [];
		raw.push(datos[i].descripcion);
		raw.push(datos[i].amortizable);
		raw.push(datos[i].idSap = null? "": datos[i].idSap);
		raw.push(datos[i].idApartado);
		data.push(raw);
	}		
	
	var table = $('#cataApartados').DataTable({
	     data: data,
	     columns: [
	         { title: "Apartado" },	         
	         { title: "Tipo Amortizable" },
	         { title: "Codigo SAP"  }	         	        
	     ],        
		 createdRow: function ( row, data, index ) {	    			    		
			 	//Se agrega el link pare ver el apartado
				var urlAction = contextPath + '/catalogos/bolsas/altaApartado.action?pmn=44' +                                                                             
						         '&idApartado=' + datos[index].idApartado +
				                 '&descripcion=' + data[0] +
				                 '&amortizable=' + data[1] +
				                 '&idSAP=' + data[2];
				html = '<a href="'+urlAction+'">'+ data[0] +'</a>';
				$('td', row).eq(0).empty().append(html);						  							
	      },	             
			 language: {
		        "sProcessing":    "Procesando...",
		        "sLengthMenu":    "Mostrar _MENU_ registros",
		        "sZeroRecords":   "No se encontraron resultados",
		        "sEmptyTable":    "No hay contratos que satisfagan los criterios de b\u00FAsqueda.",
		        "sInfo":          "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
		        "sInfoEmpty":     "Mostrando registros del 0 al 0 de un total de 0 registros",
		        "sInfoFiltered":  "(filtrado de un total de _MAX_ registros)",
		        "sInfoPostFix":   "",
		        "sSearch":        "Buscar:",
		        "sUrl":           "",
		        "sInfoThousands":  ",",
		        "sLoadingRecords": "Cargando...",
		        "oPaginate": {
		            "sFirst":    "Primero",
		            "sLast":    "&Uacute;ltimo",
		            "sNext":    "Siguiente",
		            "sPrevious": "Anterior"
		        },
		        oAria: {
		            "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
		            "sSortDescending": ": Activar para ordenar la columna de manera descendente"
		        }
		      },
		      "columnDefs": [],
		      bFilter: true, bInfo: false, "bSort": false,
		      scrollX: true, bPaginate: true,
		      "sPaginationType" : "full_numbers",
		      "aaSorting": [], "sAjaxDataProp":"", 
		});	
		table.columns.adjust().draw();		
}	

function limpiarTabla(){
	$("#divApartados").empty();
	$("#cataApartados").remove();
	var table = $("<table class='table table-striped'/>").attr('id',"cataApartados");       
	$("#divApartados").append(table);	
}