var idEstudio;

$(document).ready(
	function() {
		inicial();
	}
);

function inicial(){
	limpiarTabla();
	realizaConsulta();
	inicializarBotones();
	$("table thead tr").addClass("encabezado");
}

function limpiarTabla(){	
	$('#divTablaIn').remove();
	var div = '<div id="divTablaIn"></div>';
	$('#divTablaExt').append(div);
	var tabla = $("<table class='table table-striped'/>").attr('id',"cataEstudio");       
	$("#divTablaIn").append(tabla);	
}

function realizaConsulta(){				
	// Obtener numero de menu
	var menu        = $("#pmn").val();
	var menuRegreso = $("#pmnReturn").val();
	var namespace = "/catalogos/addons/";
    var rowId=null;
    var oTable=null;
     oTable=$('#cataEstudio').dataTable({		    
	   "bAutoWidth": false,
		"oLanguage":{	"sProcessing":     "Procesando...",
						"sLengthMenu":     "Mostrar _MENU_ registros",
						"sZeroRecords":    "Sin eventos encontrados",
						"sEmptyTable":     "Sin eventos encontrados",
						"sInfo":           "Mostrando  _START_ al _END_ de  _TOTAL_ ",
						"sInfoEmpty":      "0 registros",
						"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
						"sSearch":         "Buscar:",
						"sInfoThousands":  ",",
						"sLoadingRecords": "Cargando...",
						"oPaginate": {
							"sFirst":    "Primero",
				        	"sLast":     "&Uacute;ltimo",
				        	"sNext":     "Siguiente",
				        	"sPrevious": "Anterior"
				    	}
				},
		"iDisplayLength": 10,
		"bInfo"     : false,
		"bFilter"   : true,
		"bSort"     : false,
		"bPaginate" :true,
		"sPaginationType" : "full_numbers",
		"aaSorting": [],
		"sAjaxSource": "listadoEstudiosAddons",
		"sAjaxDataProp":"", 
	    "aoColumns": [
						{"sTitle":"Nombre", 					"mDataProp":"nombre",		"bSearchable": true, sWidth : "100px"},
						{"sTitle":"Addon", 						"mDataProp":"addon",		"bSearchable": true, sWidth : "50px"},
						{"sTitle":"Reducci\u00F3n de clientes", "mDataProp":"reduClientes",	"bSearchable": true, sWidth : "50px"},
						{"sTitle":"Reporte", 					"mDataProp":"formula",		"bSearchable": true, sWidth : "500px"}
	          			],
	    		        'fnRowCallback': function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
	    		        
	    		        	var link = '<a onClick="guardaIdEstudio('+aData["idEstudio"]+')" data-toggle="modal" data-target="#modalAgregaActualiza"> ' + aData["nombre"] +'</a>';
	    		        	
	    		        	$(nRow).attr("id",aData["idEstudio"]);
	    		        	$('td:eq(0)', nRow).html(link);
		          			$('td:eq(1)', nRow).html(aData["addon"]);
	    		        	$('td:eq(2)', nRow).html(aData["reduClientes"]);
	    		        	$('td:eq(4)', nRow).html(aData["formula"]);
	   		       		}
		});
     
}

function validarAgregar(){
	
	$("#forma").validate(
		      {
		        rules: 
		        {
		        	nombreEstudio: 
		          {
		            required: true,
		            maxlength: 50,
		            regex:"^[a-zA-Z0-9 ]+$"
		          }
		        },
		        messages: 
		        {
		        	nombreEstudio: 
		          {
		            required: "Nombre del Estudio es obligatorio.",
		            maxlength: "Nombre no debe exceder 50 caracteres",
		            regex: "Nombre debe ser con caracteres alfanumericos"
		          }
		        }
	});
	
	$.validator.addMethod("regex",function(value,element,regexp){
	      var re= new RegExp(regexp);
	      return this.optional(element) || re.test(value);
	},"Only Characters from A-z");
}

function inicializarBotones(){
	$("#nuevo").click(function()  
	{		
		window.location.href = contextPath + "/catalogos/addons/dirigirAgregarEstudio.action?pmn=210&pmnReturn=210";				
	});
}

function regreso(){	
	var menu = $("#pmn").val();
	if(menu == '' || menu == null || menu == undefined)
		menu = 210;
	window.location.href = contextPath + "/catalogos/addons/index.action?pmn=" + menu;
}

function guardaIdEstudio(idEstud) {	
	idEstudio = idEstud;
	llamaObtenEstudio(idEstud);
}

function llamaObtenEstudio(idEstudio) {
	var jsonString = '{"idEstudio" : "'+ idEstudio +'"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/addons/llamaObtenAddon", stringJson, procesaRespuestaObtenEstudio);
}

function procesaRespuestaObtenEstudio(jsonData) {
	//console.info(JSON.stringify(jsonData));
	var est = jsonData.estudio;
	var reps = jsonData.reportes;
	var rep;
	//debugger
	$('#inpNombreEstudio').val(est.nombre);
	$('#inpSigla').val(est.addon);
	$('#inpReduClientes').val(est.reduClientes);
	
	$('#campoReporte').children().remove();
	
	var option;
	for(var i = 0; i < reps.length; i++){
		rep = reps[i];
		console.log('**************' + rep.idReporte + '******************' + est.idReporte);
		if(est.idReporte == rep.idReporte) {
			$('#campoReporte').append('<option value="'+ rep.idReporte +'" selected> '+ rep.descFormula +' </option>');
		}else {
			console.log(rep.idReporte);
			$('#campoReporte').append('<option value="'+ rep.idReporte +'"> '+ rep.descFormula +' </option>');
		}						
	}
}

function llamaActualizaEstudio() {
	
	var adon = $('#inpSigla').val();
	var nombre = $('#inpNombreEstudio').val();
	var reduclientes = $('#inpReduClientes').val();
	var jsonString = '{"idEstudio" : "'+ idEstudio + '", "adon" : "' + adon + '", "nombreEstudio" : "' + nombre 
		+ '", "redClientes" : "' + reduclientes+ '", "reporte" : "' + $('#campoReporte').val() +'"}';	
	console.log(jsonString);
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/addons/llamaActualizaAddon", stringJson, procesaRespuestaActualiza);

}

function procesaRespuestaActualiza(jsonData) {
	
	var seRepite = jsonData.seRepiteSigla;
	
	$('#modalAgregaActualiza').modal('hide');
	
	if(!seRepite) {
		showMessage("Actualizado con exito");
	}else {
		showError("La sigla se repite en otro Estudio.");
	}
	
	inicial();	
}

function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	console.log(actionRoute);
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	         console.error("Error: " + textStatus + " ::: " + errorThrown + " ::: " + jqXhr);
	         showError("Problemas al enviar los datos.");
	     }
	 });	
}