var tipoCambioController = function($scope, $filter, tipoCambioService){
	
	$scope.annios = [];
	$scope.paises = [];
	
	tipoCambioService.obtenerAnniosPaises().then(function(data) {
		$scope.annios = data.annios;
		$scope.myannio = $scope.annios[2];
		$scope.paises = data.paises;
		$scope.mypais = $scope.paises[0];
	});
	
	$scope.consultar = function() {
		tipoCambioService.obtenerMesTipo($scope.myannio, $scope.mypais).then(function(data) {
			console.log("nombreTipos[1]", JSON.stringify(data.nombreTipos[1]));
			$scope.nombreTipos = data.nombreTipos;
			$scope.mesesTipos = data.mesesTipos;		
		});
	};
	
	$scope.limpiar = function(){
		$scope.mesesTipos = [];
	};
	
	$scope.guardarCambio = function() {
		tipoCambioService.llamarAction({"mesesTipos" : $scope.mesesTipos}, "guardarCambio").then(function(data) {
			if(data.exito) {
				showMessage(data.mensaje);
			}else {
				showError(data.mensaje);
			}
		});
	};
	
	$scope.valida = function(oldValue, newValue) {
		var patron = /^\d+(\.\d{0,6})?$/;
		var texto = newValue;
		if(texto !== null) {
			if(!patron.test(texto))
				showWarn("Esta colocando caracteres en un campo n\u00FAmerico.");
		}
		
	}
	
};

registraController("tipoCambioController", tipoCambioController);