var service;

$(document).ready(function(){	  
	    service = new PresupuestoService('');
		inicializarBotones();	    			
		mostrarTipoAmort(1);
		agregarPresupuesto();
		
		$("#btMonto").click(function()   
				{				
			agregaMonto();	
				});
		
		
		
		
		
});

function agregarPresupuesto(){
	var fecha = new Date();
	var anoActual = fecha.getFullYear();
	var anoSiguiente = fecha.getFullYear()+1;
	
	$("#anios").append($('<option>', {
	    value: anoActual,
	    text :anoActual
	}));
	$("#anios").append($('<option>', {
	    value: anoSiguiente,
	    text :anoSiguiente
	}));
} 

function validate(evt) {
	  var theEvent = evt ;
	  
	  // Handle paste
	  if (theEvent.type === 'paste') {
	      key = event.clipboardData.getData('text/plain');
	  } else {
	  // Handle key press
	      var key = theEvent.keyCode || theEvent.which;
	      key = String.fromCharCode(key);
	  }
	  var regex = /[0-9]|\./;
	  
	  if( !regex.test(key) ) {
	    theEvent.returnValue = false;
	    if(theEvent.preventDefault) theEvent.preventDefault();
	  }
	}


function mostrarTipoAmort(tipo){
	if(tipo==1)		
		service.cargarPresupuestos("Amortizable");	
	else if(tipo==2) 
		service.cargarPresupuestos("No Amortizable");
}

function mostrarAmort(presupuestos){		
	limpiarTabla("divTabla", "tabAmortizables");
    crearTablaListado(service.generarTablaListado(presupuestos), "tabAmortizables");
    if(presupuestos == null)
       $("#btConfAmor").hide();    
}

function mostrarNAmort(presupuestos){		
    limpiarTabla("divTablaNA", "tabNoAmortizables");
    crearTablaListado(service.generarTablaListado(presupuestos), "tabNoAmortizables");
    if(presupuestos == null)
       $("#btConfNAmor").hide();
}

function crearTablaListado(data, id){				
	var encabezados = $("<thead />");
	var cuerpo      = $("<tbody/>");
		
	var fila = $("<tr class='encabezado'/>");
	fila.append($("<td/>").text("A\u00F1o"));
	fila.append($("<td/>").text("Monto Asignado"));
	fila.append($("<td/>").text("Monto Comprometido"));	
	encabezados.append(fila);
	
	if(data.length == 0)
	{
		var fila = $("<tr/>");
		fila.append($("<td/>").text(""));
		fila.append($("<td align='middle'/>").text("No existen registros. Dar de alta Apartados."));
		fila.append($("<td/>").text(""));
		cuerpo.append(fila);
	}
	else 
	{
		for(var i=0; i<data.length; i++)
		{
			var fila = $("<tr/>");
			    fila.append($("<td/>").text(data[i][0]));
			    var asignado     = data[i][1] == null ? "0.0" : parseFloat(data[i][1]).formatDLA();
			    var comprometido = data[i][2] == null ? "0.0" : parseFloat(data[i][2]).formatDLA();
			    fila.append($("<td/>").text("$ " + asignado));
			    fila.append($("<td/>").text("$ " + comprometido));
			cuerpo.append(fila);
		}
	}					
	$("#"+ id).append(encabezados).append(cuerpo).addClass("table table-striped table-hover");			
}	

function limpiarTabla(idDiv, idTabla){
	$("#"+idDiv).empty();
	$("#"+idTabla).remove();
	$("#"+idDiv).append($("<table id='"+idTabla+"'/>"));
}

function inicializarBotones(){
	$("#btConfAmor").click(function()   
	{				
		$("#tipo").val("Amortizable");
		$("#forma").submit();		
	});
	
	$("#btConfNAmor").click(function()   
	{		     	  																
		$("#amortizables").val("");
		$("#tipo").val("No Amortizable");
		$("#forma").submit();
	});		
	
	
}

function agregaMonto(){
	var anio;
	var monto;
	
	var actionpath = null;
	var parametros = null;
	
	//validamos campos llenos 
    if($("#anios").val() != "" && $("#monto").val() != ""){
    	parametros     = {anio : $("#anios").val(), monto : $("#monto").val()};
    	
    	actionpath = '/presupuestos/catalogoPresupuestos/guardaMonto.action';
    	
    	if(actionpath != null)
    		$.post( contextPath + actionpath, parametros)		
    		.done(function( response ) 
    		{		
    			console.log(response);
    			if(response.mensaje != 'APLICADO')	
    				showError("Error al procesar la operaci\u00F3n.--" + response.mensaje);			      
    			else			
    			{		
    				showMessage("Monto almacenado.");
    				console.log("ECHO")	
    			}				   			       		   
    	});		
    	
    }else{
    	showError("Los campos son obligatorios");
    } 
    
	
}
