var cargaTransaccionesService = function($filter, $http, $q){
	return{
		functionTest: function(){
			return "something";
		},
		consultarCarga : function(mes){
			var defered = $q.defer();
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/consultarCarga.action',
	            data :{"mes":mes}
			}).then(function mySucces(response) {
				defered.resolve(response.data);
			}, function myError(response) {
				console.log("Error : "+response);
				console.log("Error : "+response.data);
			});
			//console.log(JSON.stringify(defered.promise));
	    	return defered.promise;
		},
		obtenerVistaPrevia : function(idCarga){
			var defered = $q.defer();
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/reporteVistaPrevia.action',
	            data :{"idCarga":idCarga}
			}).then(function mySucces(response) {
				defered.resolve(response.data);
			}, function myError(response) {
				console.log("Error : ");
			});
			//console.log(JSON.stringify(defered.promise));
	    	return defered.promise;
		},
		obtenerJsonVistaPrevia : function(ruta){
			var defered = $q.defer();
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/obtenerjsonVistaPrevia.action',
	            data :{"ruta":ruta}
			}).then(function mySucces(response) {
				defered.resolve(response.data);
			}, function myError(response) {
				console.log("Error : ");
			});
			//console.log(JSON.stringify(defered.promise));
	    	return defered.promise;
		},
		obtenerDetalleErroresCargaService : function(mes){
			var defered = $q.defer();
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/obtenerDetalleResumenCarga.action',
	            data :{"mes":mes}
			}).then(function mySucces(response) {
				defered.resolve(response.data);
			}, function myError(response) {
				console.log("Error : ");
			});
			
	    	return defered.promise;
		},
		obtenerListaErrAsocTitulosService : function(idCarga){
			var defered = $q.defer();
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/obtenerListadoErrAsocTitulos.action',
	            data :{"idCarga":idCarga}
			}).then(function mySucces(response) {
				defered.resolve(response.data);
				
			}, function myError(response) {
				console.log("Error al recuperar listado obtenerListaErrAsocTitulosService ");
			});
			
	    	return defered.promise;
		},		
		descargarArchivo: function(dataIn){
			var defered = $q.defer();	
				
			$http.post(contextPath + '/carga/transacciones/descargaArchivo.action', dataIn, {responseType : 'arraybuffer'})
			.success(function(data, status, headers) {
									
				headers = headers();					
				
				//console.log("headers :", headers);
		        var filename    = headers['content-disposition'].split(";")[1].split("=")[1];					
		        var contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
		 
		        var linkElement = document.createElement('a');
		        try {
		            var blob = new Blob([data], { type: contentType });
		            var url = window.URL.createObjectURL(blob);
		 
		            linkElement.setAttribute('href', url);
		            linkElement.setAttribute("download", filename);
		 
		            var clickEvent = new MouseEvent("click", {
		                "view": window,
		                "bubbles": true,
		                "cancelable": false
		            });
		            linkElement.dispatchEvent(clickEvent);
		        } catch (ex) {
		            console.log(ex);
		        }

				defered.resolve(data);
			}).error(function(err) {
				showError("Se generó un error al intentar exportar el archivo de excel.");
				defered.reject(err)
			});
			
	    	return defered.promise;
		},
		descargarArchivoVistaPrevia: function(dataIn2){
			
			var defered = $q.defer();		
				
			$http.post(contextPath + '/carga/transacciones/descargaArchivoVistaPrevia.action', dataIn2, {responseType : 'arraybuffer'})
			.success(function(data, status, headers) {
							
				headers = headers();					
				
				//console.log("headers :", headers);
		        var filename    = headers['content-disposition'].split(";")[1].split("=")[1];					
		        var contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
		 
		        var linkElement = document.createElement('a');
		        try {
		            var blob = new Blob([data], { type: contentType });
		            var url = window.URL.createObjectURL(blob);
		 
		            linkElement.setAttribute('href', url);
		            linkElement.setAttribute("download", filename);
		 
		            var clickEvent = new MouseEvent("click", {
		                "view": window,
		                "bubbles": true,
		                "cancelable": false
		            });
		            linkElement.dispatchEvent(clickEvent);  
				   
		        } catch (ex) {
		            console.log(ex);
		        }
				
				defered.resolve(data);
			}).error(function(data,err) {
				
				defered.reject(data,err);
				showError("Se generó un error al intentar exportar el archivo de excel.");
				console.log('export.Error.');
			});
			
	    	return defered.promise;
		},//fin descarga vista previa

		descargarArchivoErrAsocTitulosService: function(idCarga){
        	//debugger;
			var defered = $q.defer();		
				
			$http.post(contextPath + '/carga/transacciones/descargaReporteErrAsocTitulos.action?idCarga='+ idCarga,{headers: {'Content-Type': "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",'accept':"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}})
			.success(function(data, status, headers) {
						
				headers = headers();				
				console.log("headers :", headers);
				
				window.open(contextPath + '/carga/transacciones/descargaReporteErrAsocTitulos.action?idCarga='+ idCarga);
				
				defered.resolve(data);
			}).error(function(data,err) {
				
				defered.reject(data,err);
				showError("Se generó un error al intentar exportar el archivo de excel.");
			
			});
			
	    	return defered.promise;
		},//fin descarga archivo asociacion Titulos
		
		
		obtenerTitulosdelaCarga : function(mes){
			var defered = $q.defer();
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/obtenerTitulosdelaCarga.action',
	            data :{"mes":mes}
			}).then(function mySucces(response) {
				defered.resolve(response.data);

				//console.log("oka Titulos de la carga : ");
			}).then(function myError(response) {
				console.log("Error response titulosdelaCarga : ");
				
			});
			//console.log(JSON.stringify(defered.promise));
	    	return defered.promise;
		},
		
		obtenerResumenCarga : function(mes){
			var defered = $q.defer();

			$http.post(contextPath + '/carga/transacciones/obtenerResumenCarga.action', {"mes":mes})
			.success(function(response) {
				console.log("ok. obtener resumen carga ");
				console.log(response);
				defered.resolve(response);
			}).error(function(err) {
				console.log("Error al obtener resumen carga ");
				console.log(err);
                defered.reject(err);
			});
			
	    	return defered.promise;
		},
		
		obtenerResumenCargaIdTrans : function(idCarga){
			var defered = $q.defer();
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/obtenerResumenCargaIdTrans.action',
	            data :{"idCarga":idCarga}
			}).then(function mySucces(response) {
				defered.resolve(response.data);

				console.log("ok. obtener resumen carga con id carga ");
				
			}).then(function myError(response) {
				console.log("Error al obtener resumen carga con idCarga ");
				
			});
			//console.log(JSON.stringify(defered.promise));
	    	return defered.promise;
		},		
		
		obtenerSinIdBroadView : function(idCarga){
			var defered = $q.defer();
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/obtenerSinIdBroadView.action',
	            data :{"idCarga":idCarga}
			}).then(function mySucces(response) {
				defered.resolve(response.data);

				//console.log("oka SinIdBroadVied : ");
				
			}).then(function myError(response) {
				console.log("Error response sinIdBroadView : ");

			});
			//console.log(JSON.stringify(defered.promise));
	    	return defered.promise;
		},
		
		obtenerIdBroadViewNoExiste : function(idCarga){
			var defered = $q.defer();
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/obtenerIdBroadViewNoExiste.action',
	            data :{"idCarga":idCarga}
			}).then(function mySucces(response) {
				defered.resolve(response.data);

				//console.log("oka IdBroadViewNoExiste : ");
				
			}).then(function myError(response) {
				console.log("Error response obtenerIdBroadViewNoExiste : ");
			
			});
			//console.log(JSON.stringify(defered.promise));
	    	return defered.promise;
		},
		
		obtenerTituloyFilialNoExiste : function(idCarga){
			var defered = $q.defer();
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/obtenerTituloyFilialNoExiste.action',
	            data :{"idCarga":idCarga}
			}).then(function mySucces(response) {
				defered.resolve(response.data);

				//console.log("oka obtenerTituloyFilialNoExiste : ");
				
			}).then(function myError(response) {
				console.log("Error response obtenerTituloyFilialNoExiste : ");
				
			});
			//console.log(JSON.stringify(defered.promise));
	    	return defered.promise;
		},
		
		obtenerTituloFueradePeriodo : function(idCarga){
			var defered = $q.defer();
			//console.log(idCarga);
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/obtenerTituloFueradePeriodo.action',
	            data :{"idCarga":idCarga}
			}).then(function mySucces(response) {
				defered.resolve(response.data);

				console.log("oka obtenerTituloFueradePeriodo : ");
				//console.log(response);
				//debugger;
			}).then(function myError(response) {
				console.log("Error response obtenerTituloFueradePeriodo : "+response);
				
			});
			
	    	return defered.promise;
		},
		
		actualizaIdBv : function(idBv,id_carga_titulo,nombreEstandar){
			var defered = $q.defer();
			//console.log("pasan datos: "+idBv+ "    "+id_carga_titulo+"    "+nombreEstandar);
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/actualizarIdBv.action',
	            data :{"idBv":idBv, "id_carga_titulo":id_carga_titulo, "nombreEstandar":nombreEstandar}
	
			}).then(function mySucces(response) {
				defered.resolve(response.data);

				//console.log("oka obtenerTituloFueradePeriodo : ");
				
			}).then(function myError(response) {
				console.log("Error response obtenerTituloFueradePeriodo : "+response);
				
			});
			
	    	return defered.promise;
		},
		validaCargaService : function(idCarga){
			var defered = $q.defer();
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/validaCarga.action',
	            data :{"idCarga":idCarga}
	
			}).then(function mySucces(response) {
				defered.resolve(response.data);

				console.log("OK. se valido Carga : ");
				
			}).then(function myError(response) {
				console.log("Error response en validaCargaService : "+response);
				
			});
			
	    	return defered.promise;
		},
		reCalculoPago : function(idCarga){
			var defered = $q.defer();
			console.log(idCarga);
		
			$http({
				method : "POST",
	            url : contextPath + '/carga/transacciones/reCalculoPago.action?idCarga='+idCarga
	            //data :{"idCarga":idCarga}
			}).then(function mySucces(response) {
				
				defered.resolve(response.data);
				
			}).then(function myError(response) {
				console.log("Error response obtenerTituloyFilialNoExiste : ");
				
			});

	    	return defered.promise;
		}

		
	};
};

registraService("cargaTransaccionesService", cargaTransaccionesService);