function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){

	         alert("Error: " + textStatus + " ::: " + errorThrown + " ::: " + jqXhr);
	     }
	 });
	
}

function cargaTablasBroadview(filtroTablas){
	
	 var opcionDeal = $('#capturaDeal').val();
	
	 /*	 
	 if (validaNuloUndefinido(opcionDeal) != 0){*/
	  
	     var jsonString = '{"muestraTodos" : ' + filtroTablas + ', "deal" : ' + opcionDeal + '}';
	     var stringJson = JSON.parse(jsonString);
	     callActionAjax( "/contrato/broadview/cargaBroadviewData", stringJson, generaTablasBroadview);
	     
//	 }
}


function generaTablasBroadview(jsonData){
	
	var broadviewListaNoAsignada = jsonData.broadviewTitulosListaNoAsignados;
	var dlaListaNoAsignada = jsonData.dlaTitulosContratoNoAsignados;
	
	var broadviewListaAsignada = jsonData.broadviewTitulosListaAsignados;
	var dlaListaAsignada = jsonData.dlaTitulosContratoAsignados;
	
	 $('#' + "broadviewTablaContenedorDesasignados").remove();
	 $('#' + "ddaTablaContenedorDesasignados").remove();
	 $('#' + "broadviewTablaContenedorAsignados").remove();
	 $('#' + "ddaTablaContenedorAsignados").remove();
	
	if (dlaListaNoAsignada.length != 0 || broadviewListaNoAsignada .length != 0){
	       generaTablaBroadview("broadviewTablaPosicionDesasignados", "broadviewTablaContenedorDesasignados", "broadviewTablaDesasignados", broadviewListaNoAsignada);
	       generaTablaDla("ddaTablaPosicionDesasignados", "ddaTablaContenedorDesasignados", "ddaTablaDesasignados", dlaListaNoAsignada, 0);
    }
	
	if (dlaListaAsignada.length != 0 || broadviewListaAsignada .length != 0){
	       generaTablaBroadview("broadviewTablaPosicionAsignados", "broadviewTablaContenedorAsignados", "broadviewTablaAsignados", broadviewListaAsignada);
	       generaTablaDla("ddaTablaPosicionAsignados", "ddaTablaContenedorAsignados", "ddaTablaAsignados", dlaListaAsignada, dlaListaNoAsignada.length);
     }
	
	cargaLibreriaEfectoArrastre();
	
}

function generaTablaBroadview(idNombreTablaPosicion, idNombreTablaContenedor, idNombreTabla, broadviewLista){
	
	var broadviewListaTamanio = broadviewLista.length;

    $('#' + idNombreTablaContenedor).remove();

	var tabla =  '<div id="'+ idNombreTablaContenedor +'" >'+  
		            '<table id="'+idNombreTabla +'" >'+
					   '<thead class="TitulosTabla">'+
					      '<tr  class="encabezado">'+
					         '<th>Nombre Ttulo</th>'+
						     '<th>Id BroadView</th>'+
					      '</tr>'+
				       '</thead>'+
	                  
				       '<tbody class="ContenidoTabla">'+
	                   '</tbody>'+
                    '</table>'+
	             '</div>';
	
	$('#' + idNombreTablaPosicion).append(tabla);
	
	for (var i=0; i<broadviewListaTamanio; i++){
		 var detalle = broadviewLista[i];
	
		 var idTituloBroadview = detalle.idBroadview;
		 var descTituloBroadview = detalle.descripcionTitulo;
		 var validaAsignado = detalle.ddaAsignado;
		 var renderAsignado = "";

		
		 if (validaAsignado === 0)
			 renderAsignado = 
				'<div class="idcopiar" endb="no" id="'+ idTituloBroadview + '">' + idTituloBroadview + '</div>';
		 else renderAsignado = 
			    '<div class="idcopiarya" endb="si" id="'+ idTituloBroadview + '">' + idTituloBroadview + '</div>';

		 var detalle =
		'<tr>'+
			'<td>'+ descTituloBroadview +'</td>'+
			'<td class="CopiarId">'+
			     renderAsignado +	
			 '</td>'+
		'</tr>';
		 
		 $('#' + idNombreTabla + ' > tbody:last').append(detalle);

	}
	
}

function generaTablaDla(idNombreTablaPosicion, idNombreTablaContenedor, idNombreTabla,  dlaLista, pivoteFila){
	
	var dlaListaTamanio = dlaLista.length;

    $('#' + idNombreTablaContenedor).remove();

	tabla =      '<div id="'+ idNombreTablaContenedor +'" >'+     
		            '<table id="'+idNombreTabla +'">'+
					   '<thead class="TitulosTabla">'+
					      '<tr  class="encabezado">'+
					         '<th>Id BroadView</th>'+
						     '<th>Id DDA</th>'+
						     '<th>Nombre Ttulo</th>'+
					      '</tr>'+
				       '</thead>'+
	                  
				       '<tbody class="ContenidoTabla">'+
	                   '</tbody>'+
                    '</table>'+
                 '</div>';
	
	$('#' + idNombreTablaPosicion).append(tabla);
	
	for (var i=0; i< dlaListaTamanio; i++){
		 var detalle = dlaLista[i];
		 var idFila = i + pivoteFila;
		 //console.log(idNombreTabla+" " +idFila + " "+ pivoteFila);
		 var idTitulo = detalle.idTitulo;
		 var descTitulo = detalle.descTitulo;
		 var idBroadview = detalle.idBv;
		 			
		 
		 if (idBroadview === null)
			 renderAsignado = '<div class="ValueId" id="dda-idbv-' + idFila  + '"></div>';
		 else renderAsignado = 
			    '<div class="ValueId droppable valueya" endb="si" cambio="no" id="dda-idbv-' + idFila + '"><div class="idcopiar assigned" endb="si" cambio="no" id="as_' + idBroadview + '">' + idBroadview + '</div></div>';

		 var detalle =
		'<tr>'+
			'<td>' + renderAsignado + '</td>'+
			'<td id="dda-idtt-' + idFila + '">' + idTitulo + '</td>'+
			'<td id="dda-dctt-' + idFila + '">' + descTitulo + '</td>'+
		'</tr>';
		 
		 $('#' + idNombreTabla + ' > tbody:last').append(detalle);
	}
	
}


function cargaLibreriaEfectoArrastre(){
	$.getScript( contextPath + "/js/common/jquery/dragTable/draggingTable.js" ).then( function() {
		  //do this ONLY after the script is fully loaded
		});
}



function guardaBroadviewRelaciones(){
	
	var regex = 'dda-idbv-[0-9]+' ;
	var jsonString = '{';
	var count = 0;
	
	$('div').filter(function() {
	     return this.id.match(new RegExp(regex));
	}).each(function (i, obj) {
		
		var idDivEditable = obj.id;
		//console.log(idDivEditable);

		var guardarFlag = $( '#' + idDivEditable ).attr( 'class');
		
		console.log(idDivEditable + " : " + guardarFlag);
		
		if(guardarFlag.toLowerCase().search( 'valueya' ) != -1){
		
			  idRow = obtenNSplitPorSeparador(idDivEditable, "-", 2);
			  idDDATituloRow = "dda-idtt-" + idRow;
			
			  var idTitulo = $('#' + idDDATituloRow).text();
			  var idContrato = $('#idContrato').val();
			  var idBroadview = $('#' + idDivEditable + ' div:first-child').text();
			  
			  console.log(idDDATituloRow + " : " + idBroadview);

			  
			  if (validaNuloUndefinido(idContrato) == 0)
				  idContrato = null;

			  if (validaNuloUndefinido(idTitulo) == 0)
				  idTitulo = null;

			  if (validaNuloUndefinido(idBroadview) == 0)
				  idBroadview = null;

			  jsonString = jsonString + '"titulosDdaActualizados[' + count + '].idContrato":' + idContrato + ',"titulosDdaActualizados[' + count + '].idTitulo":' + idTitulo + ',"titulosDdaActualizados[' + count + '].idBv":' + idBroadview + ',';

			  count++;
	    }
	 });
	
	
	jsonString = jsonString.substr(0, jsonString.length -1 ) + '}' ;
	console.log(jsonString);
	
	if (count > 0){
	    var stringJson = JSON.parse(jsonString);
	    callActionAjax( "/contrato/broadview/guardaDDATitulos", stringJson, recargaTablasBroadView);
	}
}


function recargaTablasBroadView(data){
      cargaTablasBroadview(0);
}

 

function obtenNSplitPorSeparador(cadena, separador, nOcurrencia) {
	var ocurrencias = cadena.split(separador);
	return ocurrencias[nOcurrencia];
}



function validaNuloUndefinido(variable){
	
	if( (variable === null && typeof variable === "object") ||
	    (variable === undefined && typeof variable === "undefined") ||
	    (variable === "" && typeof variable === "string")
	  ){
		return 0;
	   }else {  
		return variable;
	   }
}


function guardaDealContrato(){
	
	  var dealChoice = $('#capturaDeal').val();
	  
	  if (validaNuloUndefinido(dealChoice) == 0)
		  dealChoice = null;
	  
	  var jsonString = '{"contratoConsulta.idBv":' + dealChoice + '}';
	  var stringJson = JSON.parse(jsonString);
	
	  callActionAjax( "/contrato/broadview/guardaBroadviewContrato", stringJson, recargaDealContrato);

}

function recargaDealContrato(data){
	
	 var opcionDeal = $('#capturaDeal').val();
	  if (validaNuloUndefinido(opcionDeal) != 0){		  
		    $('#capturaDeal').attr('readonly', true);
	  }

}


function validaDealContrato(){
	callActionAjax( "/contrato/broadview/cargaBroadviewContrato", null, evaluaDealValor);
}


function evaluaDealValor(jsonData){
	  var dealValor = jsonData.deal;
	  
	  if (validaNuloUndefinido(dealValor) != 0){
		  
		    $('#capturaDeal').val(dealValor);
		    $('#capturaDeal').attr('readonly', true);
			cargaTablasBroadview(0);
		    
	  }else{
			
		    $('#consultaDeal').attr('disabled', true); 
			$('#consultaTodosLink').bind('click', false);
			$('#guardaDDATitulos').attr('disabled', true);

	  }
	  
}

function checaDealValor(){
	  var dealEleccion = $('#capturaDeal').val();

	  if (validaNuloUndefinido(dealEleccion) == 0){
		  
			$('#consultaDeal').attr('disabled', true); 
			$('#consultaTodosLink').bind('click', false);
			$('#guardaDDATitulos').attr('disabled', true);
			
	  }else{
		  
			$('#consultaDeal').attr('disabled', false); 
			$('#consultaTodosLink').unbind('click', false);	
			$('#guardaDDATitulos').attr('disabled', false);
		}
}

function esNumeroEntero(evt){
	    var charCode = (evt.which) ? evt.which : event.keyCode;
	    if (charCode > 31 && (charCode < 48 || charCode > 57))
	        return false;
	    return true;
}


  function confirm(heading, question, cancelButtonTxt, okButtonTxt, callback) {

	    var confirmModal = 
	        $(
	      '<div class="modal fade" id="myModal" role="dialog">'+
	      '<div class="modal-dialog modal-sm">'+
	        '<div class="modal-content">'+
	          '<div class="modal-header">'+
	            '<button type="button" class="close" data-dismiss="modal">&times;</button>'+
	            '<h4 class="modal-title">' + heading +'</h4>'+
	          '</div>'+
	          '<div class="modal-body">'+
	            '<p>' + question + '</p>'+
	          '</div>'+
	          '<div class="modal-footer">'+
	            '<a href="#" id="okButton" class="btn btn-success">' + 
	              okButtonTxt + 
	            '</a>' +
	            '<a href="#" data-dismiss="modal" class="btn btn-primary">' + 
	              cancelButtonTxt + 
	            '</a>' +

	           '</div>'+
	        '</div>'+
	      '</div>'+
	    '</div>');
	 
	    confirmModal.find('#okButton').click(function(event) {
	        callback();
	        confirmModal.modal('hide');
	      });

	      confirmModal.modal('show');  
	      
	      confirmModal.on('hidden.bs.modal', function () {
	          $(this).remove();
	      });
	      
  };  


$(document)
.ready(
	function() {
		
		validaDealContrato();
		
	    $("#guardaDDATitulos").click(function(event) {

	        var heading = 'Guardar broadview titulos';
	        var question = 'Esta seguro que desea guardar los cambios?';
	        var cancelButtonTxt = 'Cancelar';
	        var okButtonTxt = 'Guardar';

	        var callback = function() {
	  	        guardaBroadviewRelaciones();
	  	        guardaDealContrato();	        
	  	     };

	        confirm(heading, question, cancelButtonTxt, okButtonTxt, callback);

	      });
		
	}
);
    