function TituloController() {	
	this.formManager = new FormManager();
	this.service     = new TituloService();	
	this.componentesGenerales();
	this.grid     = new TituloGrid("tituloGird");
	this.uploader = new UploaderEX("cargaTitulosDiv" , this.onUpload , this.grid );
	this.reloadGrid();

	$('div[id="divBotonesTitulo"] button').prop("disabled", true);
	$('#bExportarLista').prop("disabled", true);
	var perfil = new PerfilController();
    perfil.ejecutarPerfil(parseInt(pmn));	     	    
};

TituloController.prototype.open = function(modal , obj) {
	$("#errPerCat").hide();
	if ($("#idLAvalable").val() == $("#idFormaBusqueda [name=idLista]").val())
	{	
		$("#id"+modal+" [name=fechaFin]")   .datepicker("option", "minDate", null);
		$("#id"+modal+" [name=fechaInicio]").datepicker("option", "maxDate", null);
		
		$("#id"+modal+" [name=fechaInicio]") .datepicker('option', 'onClose', function(selectedDate) {
			$("#id"+modal+" [name=fechaFin]").datepicker("option", "minDate", selectedDate);
		});
		
		$("#id"+modal+" [name=fechaFin]").datepicker('option', 'onClose', function(selectedDate) {
			$("#id"+modal+" [name=fechaInicio]").datepicker("option", "maxDate", selectedDate);
		});
		this.formManager.limpiarForma("id"+modal);
		if((typeof obj != 'undefined'  && obj != null ))
		{
			this.formManager.llenarForma(obj, "id"+modal, this.grid.getColumns());
		}
		$('#modal'+modal).modal('show');
	}
	else
	{
		showError("No es posible efectuar la accion");
	}
	
};

TituloController.prototype.alta = function() {
	$("#errPerCat").hide();
	if($("#idEditForm").valid())
	{		
		var me = this;
		var titulo = this.formManager.leerForma('idEditForm', this.grid.getColumns());		
	
		$("#errPerCat").hide();
		this.service.guardarTitulos("EDITAR", titulo, null, function (ret) {
				if(ret.mensaje != null)
				{					
					me.service.titulo = titulo;				
					$('#divAddSeries').modal('show');
				}				   				
				else
				{
					showMessage("Datos guardados correctamente");
					me.reloadGrid();
					//me.cargaSugerencias();
					$('#modalEditForm').modal('hide');
				}				
		});					
    }
};

TituloController.prototype.altaSeriesAutomatico = function() {
	$("#errPerCat").hide();
	var me = this;
	this.service.guardarSeriesAuto(this.service.titulo, function (ret) {		
		me.reloadGrid();
		//me.cargaSugerencias();
		$('#divAddSeries') .modal('hide');
		$('#modalEditForm').modal('hide');
		showMessage("Datos guardados correctamente");
	});							
};

TituloController.prototype.openCambio = function() {
	console.log("abrir ventana")
	if ($("#idLAvalable").val() == $("#idFormaBusqueda [name=idLista]").val())
	{
		var titulo = this.grid.itemsSelected();
		if(titulo.length == 1)
		{
			this.open("EditForm", titulo[0]);
		}
		else
		{
			showError("Debe seleccionar un registro");
		}
	}
	else
	{
		showError("No es posible efectuar la accion");
	}
};

TituloController.prototype.openBaja = function() {
	if ($("#idLAvalable").val() == $("#idFormaBusqueda [name=idLista]").val())
	{
		console.log("abrir ventana baja")
		var titulo = this.grid.itemsSelected();
		if(titulo.length == 1)
		{
			var a = titulo[0];
			$(".descTituloElim").html(a.descTitulo);
			if(a.idSap == '' || a.idSap == null || typeof a.idSap == 'undefined' )
			{
				this.open("Eliminar", titulo[0]);
			}
			else
			{
				if(a.fechaInicio != null){
					var valueF =  this.formManager.
						changeDateFormat(this.formManager.dateFormatIn, this.formManager.dateFormatOut,  a.fechaInicio) ;
					$("#idFechaFinModalEliminar").datepicker("option", "minDate", valueF);
				}
				this.open("EliminarSAP", titulo[0]);
			}
		}
		else
		{
			showError("Debe seleccionar un registro");
		}
	}
	else
	{
		showError("No es posible efectuar la accion");
	}
};

TituloController.prototype.baja = function(modal) {
	if($("#id"+modal).valid())
	{
		var me = this;
		var a = this.formManager.leerForma("id"+modal, this.grid.getColumns());
		this.service.eliminarTitulos(a, function () {
			showMessage("Datos guardados correctamente");
			me.reloadGrid();
			//me.cargaSugerencias();
		});
		$('#modal'+modal).modal('hide');
	}
};

TituloController.prototype.openCambioMultiple = function(modal) {
	if ($("#idLAvalable").val() == $("#idFormaBusqueda [name=idLista]").val())
	{
		console.log("abrir ventana cambio multiple modal")
		var titulo = this.grid.itemsSelected();		
			
		if(titulo.length != 0)
		{
			this.open(modal, titulo[0]);
		}
		else
		{
			showError("Debe seleccionar al menos un registro");
		}
	}
	else
	{
		showError("No es posible efectuar la accion");
	}
};

TituloController.prototype.cambioMultiple = function(cambio,modal) {
	if($("#id"+modal).valid())
	{
		var me = this;
		var titulo = this.formManager.leerForma("id"+modal, this.grid.getColumns());
			
		console.log("abrir ventana cambio multiple cambio modal")
		var v = this.grid.itemsSelected();
				
		if(v.length != 0 && v[0] == null)
		   v.shift();   //Se remueve el primer elemento que es la informacion del total
		
		var indx = "";
		for(var i =0; i<v.length;i++)
		{
			indx+=v[i].idTituloCnt+",";
		}
		
		this.service.guardarTitulos(cambio, titulo, indx, function () {
			showMessage("Datos guardados correctamente");
			me.reloadGrid();
			//me.cargaSugerencias();
		});
		$('#modal'+modal).modal('hide');
	}
};

TituloController.prototype.guardarCambios = function() {
	this.service.guardarCambios();
};


TituloController.prototype.exportarBusqueda = function()
{
	this.service.descargarArchivo();
};

TituloController.prototype.buscarPresupuesto =  function ()
{
	var p = this.service.buscarPresupuesto();
	var columns = [
	               {name:"amortizable"},
	               {name:"comprometido"},
	               {name:"disponible"},
	               {name:"contratoActual"},
	               {name:"amortizableEstudio"},
	               {name:"comprometidoEstudiod"},
	               {name:"disponibleEstudio"}
	               ]; 
	this.formManager.llenarForma(p, "idFormPresupuesto", columns);
	$("#presupuestoDiv").show();
	if(p.errores != null)
	{
		if(p.errores.length != 0){showError(p.errores);}
	}
	if(p.mensajes != null)
	{
		if(p.mensajes.length != 0){showMessage(p.mensajes);}
	}
	
};

TituloController.prototype.reloadGrid =  function ()
{
	this.grid.reload();	
}

TituloController.prototype.descargarArchivoErrores = function()
{
	this.service.descargarArchivoErrores();
};

TituloController.prototype.componentesGenerales = function() {
	this.formManager.initForm("idEditForm" , {
		rules : {
			"mesesExclusivo" : {
				required : function ()
				{
					return $("#pjeExclusivo") != null && $("#pjeExclusivo").val() != '';
				},
				digits: true
				
			},
			"pjeExclusivo" : {
				required : function ()
				{
					return $("#mesesExclusivo") != null && $("#mesesExclusivo").val() != '';
				},
				digits: true,
				range: [0, 100]
				
			},			
			"descTitulo" : {
				 required: true,
			     maxlength: 200
			},			
			"nombreUnico" : {
				 required: true,
			     maxlength: 200
			},			
			"temporada" : {				 
			     maxlength: 10
			},
			"episodio" : {				 
			     maxlength: 10
			},
			"idBv" : {				 
			     maxlength: 12
			}						
		}
	});
	this.formManager.initForm("idEliminar");
	this.formManager.initForm("idEliminarSAP");
	this.formManager.initForm("idCategoriaForm");
	this.formManager.initForm("idVentanaForm");
	
	$("#idCategoriaForm [name=pagoCateg]").select({
		url : contextPath +'/contrato/license/titulos/buscaCategoriasDDAFechaTituloAsync.action',
		root : 'categoriasDDAFecha',
		async : false,
		fields : {
            value  : 'value',
            text : 'desc'
        }
	});
	
	$("#idFormaBusqueda [name=idLista]").select({
		url : contextPath +'/contrato/license/titulos/buscaListasTituloAsync.action',
		root : 'listas',
		displayZero : true,
		async : false,
		fields : {
            value  : 'value',
            text : 'desc'
        }
	});
	
	$("#idEditForm [name=categoriaTit]").select({
		url : contextPath +'/contrato/license/titulos/buscaCategoriaContratoTituloAsync.action',
		root : 'categoriaContrato',
		displayZero : false,
		async : false,
		fields : {
            value  : 'value',
            text : 'desc'
        }
	});
	
	$("#idEditForm [name=pagoCateg]").select({
		url : contextPath +'/contrato/license/titulos/buscaCategoriasDDAFechaTituloAsync.action',
		root : 'categoriasDDAFecha',
		displayZero : false,
		async : false,
		fields : {
            value  : 'value',
            text : 'desc'
        }
	});
	
	//this.cargaSugerencias();
};

TituloController.prototype.openCargarDocumento = function()
{
	if ($("#idLAvalable").val() == $("#idLista").val())
	{
		this.uploader.opentUploader();
	}
	else
	{
		showError("No es posible efectuar la accion");
	}
};

TituloController.prototype.onUpload = function(data , grid )
{
	if(data.error == '' || data.error == null)
	{
		if(data.tipoCarga == 'N')
		{
			$("#idFormaBusqueda [name=idLista]").select({
				url : contextPath +'/contrato/titulos/buscaListasTituloAsync.action',
				root : 'listas',
				displayZero : true,
				async : false,
				fields : {
		            value  : 'value',
		            text : 'desc'
		        }
			});
		}
		
		    var resp = data.respuestaExcel;
			//showMessage("El documento ["+data.fileFileName+"] se ha subido con exito");
			$("#idLAvalable").val(resp.lista.idLista);
			
			grid.reload();
			
			$('#modalCarga').modal('hide');
			
			
			$("#totalResultFile").html(resp.response.datosCarga.TOTAL_REGISTROS);
			$("#cargadoResultFile").html(resp.response.datosCarga.TOTAL_CARGADOS);
			$("#rechazatoResultFile").html(resp.response.datosCarga.TOTAL_ERROR);
			$("#montoResultFile").html("$ " + parseFloat(resp.monto).formatDLA());
			$('#modalResultadosCarga').modal('show');
			
			if(resp.response.datosCarga.TOTAL_ERROR != 0) {
				$("#errorFile").show();
			}
			else {
				$("#errorFile").hide();
			}
		
		
	}
	else{
		showError(data.error);
		$('#modalCarga').modal('hide');
	}
};

TituloController.prototype.muestraFechaCarga = function(item)
{
	if($(item).val() == 'N')
	{
		$("#fechaInicioNuevaDiv").show();
	}else
	{
		$("#fechaInicioNuevaDiv").hide();
	}
};

TituloController.prototype.startUpload = function(item)
{
	var nameModal = "modalCarga";
	this.uploader.startUpload(nameModal);
};

TituloController.prototype.openDialogAmortizacion = function (value) 
{
	var gridAmort = new AmortizacionGrid("amortizacionGrid"); 
	
	gridAmort.obtenerPintarDatos(value);
};

TituloController.prototype.cargaDetalle = function (val) 
{
	this.grid.reloadDetails( val);
};

TituloController.prototype.actualizaAmortizacion = function (val) 
{
	var me = this;
	$.ajax({
		url : contextPath +'/contrato/license/titulos/calculaAmortizacionTituloGrid.action',
		type : "post",
		success : function (ret)
		{
			me.reloadGrid();
		},
		error : function ( jqXHR,  textStatus,  errorThrown )
		{
			showError("Ocurrio un error");
		}
	});
};

var tituloController;

$().ready(function() {

	//*****Se necesita para quitar bug boostraop jquery dialog****
	var bootstrapButton = $.fn.button.noConflict();
	$.fn.bootstrapBtn = bootstrapButton;
	//***************************************************
	
	tituloController = new TituloController();
});

