function TerminoService(){
	
	this.verificarPago = function(pago) {		
		var resultado = {validacion : true, mensaje: null};		
		if(pago.monto  == null || pago.monto  == "")
			resultado.mensaje = "Monto no debe ser vac\u00EDo.";
		else if(isNaN(pago.monto))
			resultado.mensaje = "El monto debe ser un n\u00FAmero correcto.";
		//if(pago.descripcion  == null || pago.descripcion  == "")
			//resultado.mensaje = "Descripci\u00F3n no debe ser vac\u00EDo.";
		if(pago.fecha  == null || pago.fecha  == "")
			resultado.mensaje = "Fecha no debe ser vac\u00EDa.";
		if(resultado.mensaje != null)
			resultado.validacion = false;
	    return resultado;
	};
	
	this.verificarTitulo = function(titulo) {
		
		var resultado = {validacion : true, mensaje: null};		
		if(titulo.porcentaje  == null)
		   mensaje = "Porcentaje no debe ser vac\u00EDo.";		
		if(resultado.mensaje != null)
			resultado.validacion = false;
	    return resultado;
	};
}

TerminoService.prototype.validarTermino = function(termino, costo) {    
	var mensaje = "";
	var valido =  true;
	
	//Se valida que se registre algun tipo de pago
	if(termino.pagoAnticipado       == null && termino.pagoMensual    == null && 
	   termino.pagoInicioExhibicion == null && termino.pagoPeriodicos == null)
	{
		mensaje = "Se debe registrar alguna forma de pago.";
		valido  = false;
	}		   			
	else
	{
		//Se valida el registro del pago anticipado sea correcto
		if(termino.pagoAnticipado != null)
		{
			var resultado = this.verificarPago(termino.pagoAnticipado);
			if(!resultado.validacion)
				mensaje = "Verificar Pago Anticipado. " + resultado.mensaje
			valido = resultado.validacion;
			
			//Se valida que la fecha de inicio sea menor o igual a fecha inicio del contrato
			if(valido)
			{														
				var fechIniCto = $("#fechaInicioCto").val().substring(0, 10).split("-");				
				var validoFec  = false;
				
				var anioCto = parseInt(fechIniCto[0]);
				var mesCto  = parseInt(fechIniCto[1]);				
				var mesPago = parseInt($("#antFecha").val().split("/")[0]);
				var anioPago= parseInt($("#antFecha").val().split("/")[2]);
				
				if(anioPago < anioCto)
					validoFec = true;
				else if(anioPago == anioCto)				
					validoFec = mesPago <= mesCto ? true : false;
								
				if(!validoFec)
				{
					valido = false;					           
					mensaje = "Fecha de inicio del pago anticipado debe ser menor o igual a fecha inicio del contrato.";
				}							
			}
		}
			
		if(valido && termino.pagoPeriodicos != null)
		{							
			for(var i=0; i<termino.pagoPeriodicos.length; i++ )
			{
				var resultado = this.verificarPago(termino.pagoPeriodicos[i]);
				if(valido)
				{
				   if(!resultado.validacion)
					  mensaje = "Verificar Pagos Peri\u00F3dicos. " + resultado.mensaje					
				   valido = resultado.validacion;	
				}				
			}
			
			if(valido)
			{							
				if(costo != termino.costoContrato)
				{
					valido = false;
					mensaje = "La suma de los periodos m\u00E1s el anticipo, no cumple el total del costo del contrato.";
				} 
			}
		}
						
		if(valido && termino.numeroTitulos == null)
		{
			mensaje = "Se debe registrar el n\u00FAmero de t\u00EDtulos.";
			valido = false;
		}
		
		if(valido && termino.titulos.length > 0)
		{
			var numTitulos = 0;			
			for(var i=0; i <termino.titulos.length ; i++)
			{
				if(termino.titulos[i].porcentaje != null && termino.titulos[i].porcentaje != -1)
				   numTitulos += parseInt(termino.titulos[i].porcentaje);
			}							
			
			if(numTitulos != 100)
			{
				mensaje = "El porcentaje de n\u00FAmero de t\u00EDtulos no es igual a 100%.";
				valido = false;
			}
		}		
		
	}	
	
	return {mensaje:mensaje, valido:valido};
};

TerminoService.prototype.obtenerTerminos = function() {
	$.post( contextPath + '/contrato/terminos/indexobtenerTermino.action')		
	.done(function( response ) 
	{		
		if(response.mensaje != null)	
			showError("Error al procesar la operaci\u00F3n.");			      
		else			
		{			
			console.log(response)
			registrarDatosContrato(response.contrato, response.termino);
			registrarDatosTermino(response.termino);
			
			if(parseInt(response.contrato.idEstatus) != 1)
			   deshabilitarForma();
			else
			{
				deshabilitarForma();
				var perfil = new PerfilController();
			    perfil.ejecutarPerfil(parseInt($("#pmn").val()));
			}
		}				   			       		   
	});
};


TerminoService.prototype.guardarTerminos = function(termino) {	
	$.post( contextPath + '/contrato/terminos/indexguardarTermino.action', {mensaje : JSON.stringify(termino)})		
	.done(function( response ) 
	{		
		if(response.mensaje != null)	
			showError("Error al procesar la operaci\u00F3n.");			      
		else						
		{				
			limpiarForma();
			console.log(response)
			registrarDatosContrato(response.contrato, response.termino);
			registrarDatosTermino(response.termino);
			showMessage("Datos guardados correctamente.")
		}				   			       		   
	});
};

TerminoService.prototype.obtenerMontoProgramado = function(termino) {
	var totalPeriodos = 0.0;
	if(termino.pagoPeriodicos != null)
	{
		for(var i=0; i<termino.pagoPeriodicos.length; i++ )
		{
			if(termino.pagoPeriodicos[i].monto != null && termino.pagoPeriodicos[i].monto != "")
			   totalPeriodos = totalPeriodos + parseFloat(termino.pagoPeriodicos[i].monto);
		}					
	}
		
	if(termino.pagoAnticipado != null && (termino.pagoAnticipado.monto != null && termino.pagoAnticipado.monto != ""))
		totalPeriodos = totalPeriodos + parseFloat(termino.pagoAnticipado.monto);		
	return parseFloat(totalPeriodos.toFixed(2));
};