var rentaPremierService = function($filter, $http, $q) {

	return {
				
		inicializarTablas: function(x){
	    	var datos;
	    	var defered = $q.defer();  
	    	$http({
	            
	    		method : "GET",
	            url : contextPath + '/contrato/transaccion/fees/obtenerFeesPremier.action'
	            
	        }).then(function mySucces(response) {
	            	        		            	       
	        	defered.resolve(response.data.feesPremierDTO);
	        	
	        }, function myError(response) {
	            data = "error";
	        });	    	
	    	return defered.promise;
	    },
		
	    crearTablaMinimosGaranzatidosCateg: function(data, encabezados, objeto){
	    	var tabla = {encabezados:null, metadatos:null, columnasEliminar: null, datos:null, mensajes : null, valida:true, nombre: "Minimos Garantizados"};
	    	
	    	//Se crean los encabezados de una tabla
		    tabla.encabezados=[ {"valor":"Box Office", "colspan":"2"},
		   		                {"valor":"Categoria",  "colspan":"1"} ];
		    	
		    for(var i=0; i<objeto.aniosMin.length; i++)
		    	tabla.encabezados.push({"valor":objeto.aniosMin[i], "colspan":"1"});
		   	
		    //Se crean los metadatos de la tabla
		    tabla.metadatos= [  {"nombre":"rango a",   "tipo":"text", "min":1, "max":10,   "formateo":"numero"},
		   	                    {"nombre":"rango b",   "tipo":"text", "min":1, "max":10,   "formateo":"numero"},
		   	                    {"nombre":"categoria", "tipo":"String", "min":1, "max":25, "formateo":"texto"}
		   	                 ];	    	
		   	
		   	for(var i=0; i<objeto.aniosMin.length; i++)
		   	    tabla.metadatos.push({"tipo":"text", "min":1, "max":10, "formateo":"moneda"});
		   	 			   	     
		   	//Se crean los datos
		   	tabla.datos = [];
			for(var i=0; i < data.length;i++)
			{
			   		var fila = [];
			    	for(var j=0; j < data[0].length;j++)
				   	{
			    		if(data[i][j] == null || data[i][j] == "null")
			    			fila.push({"valor" : null});
			    		else if(j <= 1)
			    			fila.push({"valor" : $filter('numDigMoneda')(data[i][j],2)});
			    		else if(j > 2)
			    		    fila.push({"valor" : $filter('numDigMoneda')(data[i][j],2)});
			    		else
			    		    fila.push({"valor" : data[i][j]});
				   	}	
			    	tabla.datos.push(fila);
			}
			   	 
			tabla.mensajes = [];
			for(var i=0; i < data.length;i++)
			    tabla.mensajes.push("");
	    		    			   	 		   	 	
			perfil.ejecutarPerfil(parseInt(26));
	    	return tabla;
	    },
	    		    
	    crearTablaMinimosGaranzatidosAnio: function(data, encabezados, objeto){
	    	var tabla = {encabezados:null, metadatos:null, columnasEliminar: null, datos:null, mensajes : null, valida:true, nombre: "Minimos Garantizados"};
	    	
	    	tabla.encabezados     =[];
	    	tabla.metadatos       =[];
	    	tabla.columnasEliminar=[];
		    	
	    	for(var i=0; i<objeto.aniosMin.length; i++)
		    	tabla.encabezados.push({"valor":objeto.aniosMin[i], "colspan":"1"});
		   	
	    	for(var i=0; i<objeto.aniosMin.length; i++)
		   	    tabla.metadatos.push({"tipo":"text", "min":1, "max":10, "formateo":"numero"});
		   	 	
		   	//Se crean los datos
		   	tabla.datos = [];
			for(var i=0; i < data.length;i++)
			{
					var fila = [];
			    	for(var j=0; j < data[0].length;j++)
				   	{		    		
			    		if(data[i][j] == null)
			    			fila.push({"valor" : null});
			    		else
			    	        fila.push({"valor" : $filter('numDigMoneda')(data[i][j],2)});			    	
				   	}	
			    	tabla.datos.push(fila);
			}
			   	 
			tabla.mensajes = [""];
			for(var i=0; i < data.length;i++)
				tabla.mensajes.push("");
	    		    			   	 		   	 		   	 		   	 
	    	return tabla;
	    },
	    
	    crearTablaRelease: function(data, encabezados, objeto){
	    	var tabla = {encabezados:null, metadatos:null, columnasEliminar: null, datos:null, mensajes : null, valida:true, nombre: "Release"};
	    		    	    		    		    		    	
	    	//Se crean los metadatos de la tabla
	    	tabla.metadatos= [  {"nombre":"",  "tipo":"text",   "min":1, "max":10, "formateo":"numero"},
	   	                        {"nombre":"",  "tipo":"text",   "min":1, "max":10, "formateo":"numero"},
	   	                        {"nombre":"",  "tipo":"String", "min":1, "max":10, "formateo":"texto"}
	   	                     ];
	   		   	 
	    	tabla.datos = [];
		   	for(var i=0; i < data.length;i++)
		    {
		   	   var fila = [];
		       for(var j=0; j < data[0].length;j++)
			   {		    	   
		           if(tabla.metadatos[j].tipo != "String")		    					    			
		    			fila.push({"valor" : $filter('number')(data[i][j])});
		    		else
			    	   fila.push({"valor" : data[i][j]});
			   }	
		       tabla.datos.push(fila);
		    }
		   			   	
		   	if(tabla.datos.length == 0)
		   	{
		   	    var fila = [];
		   	    fila.push({"valor" : null});
		   	    fila.push({"valor" : null});
		   	    fila.push({"valor" : null});
		   	    tabla.datos.push(fila);
		   	}		   		
	    
		   	tabla.mensajes = [""];
		   	for(var i=0; i < data.length;i++)
		   		tabla.mensajes.push("");
		   	 
	    	return tabla;
	    },
	    
	    
	    crearTablaImpuestos: function(data, encabezados, objeto){
	    	var tabla = {encabezados:[], metadatos:null, columnasEliminar: null, datos:null, mensajes : null, valida:true, nombre: "Impuestos"};
	    		    		    	
	    	//Se crean los encabezados
	    	tabla.encabezados.push({"valor":"Impuestos", "colspan":"1"});
	    	for(var i=0; i<encabezados.length; i++)
	    		tabla.encabezados.push({"valor":encabezados[i], "colspan":"1"});
	    		    		    		    		    
	    	tabla.datos = [];		   	
		   	for(var i=0; i < data.length;i++)
		    {
		   	   var fila = null;
		   	   switch(i)
		   	   {
		   	      case 0:
		   	    	fila = [{"valor" : "Impuestos %"}]
		   	    	break;
		   	      case 1:
		   	    	fila = [{"valor" : "Aplica (S/N)"}]
		   	    	break;		   	    	
		   	      case 2:
		   	    	fila = [{"valor" : "Incluido en el costo"}]
		   	    	break;
		   	   }
		   	   
		       for(var j=0; j < data[0].length;j++)
			   {
		    		if(data[i][j] == null)
		    		   fila.push({"valor" : $filter('percentage')(0,2)});
		    		else if(i==0)		    			
		    		   fila.push({"valor" : $filter('percentage')(data[i][j])});
		    		else
			    	   fila.push({"valor" : data[i][j]});
			   }	
		       tabla.datos.push(fila);
		    }		   			   			   			  		   			   			   		   	
	        return tabla;
	    },
	    	    
	    crearTablaPrecios: function(data, encabezados, objeto){
	    	var tabla = {encabezados:[], metadatos:null, columnasEliminar: null, datos:null, mensajes : null, subEncabezadosPrecio:null, valida:true, nombre: "Precios"};
	    		    		    	
	    	for(var i=0; i<encabezados.length; i++)
	    		tabla.encabezados.push({"valor":encabezados[i], "colspan":"1"});
	    		    	
	    	tabla.datos = [];
		   	for(var i=0; i < data.length;i++)
		    {
		   	   var fila = [];
		       for(var j=0; j < data[0].length;j++)
			   {		    		    		
		    	   if(data[i][j] == null)
		    		 fila.push({"valor" : null});
		    	   else if(j>1)
		    		 fila.push({"valor" : $filter('numDigMoneda')(data[i][j], 4)});
		    	   else
		    		 fila.push({"valor" : data[i][j]});
		    		  
			   }	
		       tabla.datos.push(fila);
		    }
		   	
		   	tabla.subEncabezadosPrecio  = [];
		   	for(var j=0; j < encabezados.length;j++)
		   	{
		   		tabla.subEncabezadosPrecio.push("ML");
		   		tabla.subEncabezadosPrecio.push("Dolares");
		   	}			   		    		    		
		       		    				   		   	
	        return tabla;
	    },
	    	    
	    crearTablaRevenue: function(data, encabezados, objeto){
	    	var tabla = {encabezados:[], metadatos:null, columnasEliminar: null, datos:null, mensajes : null, valida:true, nombre: "Revenue"};
	    	
	    	tabla.datos = [];
		   	for(var i=0; i < data.length;i++)
		    {
		   	   var fila = [];
		       for(var j=0; j < data[0].length;j++)
			   {		    		    		
		    	     if(data[i][j] == null)
			    		 fila.push({"valor" : null});
		    	     else if(j>0)
		    	        fila.push({"valor" : $filter('numDigMoneda')(data[i][j], 2)});		    		    
		    	     else
		    	    	fila.push({"valor" : data[i][j]});
			   }	
		       tabla.datos.push(fila);
		    }
		   	
	        return tabla;
	    },
	    
	    crearMatriz: function(tabla){
	    	 var datos = [];
			 for(var i=0;i< tabla.datos.length;i++)
			 {
				  var fila = [];
				  for(var j=0;j< tabla.datos[0].length;j++)
				  {
					  fila[j] =  tabla.datos[i][j].valor = tabla.datos[i][j].valor != null ? tabla.datos[i][j].valor.replace("%","").replace(",","") : null;
				  }  
				  datos.push(fila);
			 }		   	
	         return datos;
	    },
	    
	    guardarPremier: function(fees, idCto, idTipoCambio){	    	
	    	  var defered = $q.defer();			  
			  var data    = { tipoFees : "Premier", feesPremierDTO : fees, idCto:idCto, tipoCambio:idTipoCambio};			  
			  			  
			  $http.post(contextPath + '/contrato/transaccion/fees/guardarFees.action', data)
						.success(function(data) {
							defered.resolve(data);
						}).error(function(err) {
							console.log(err)
							showError("Error al cargar el archivo")
						});
			  return defered.promise;			
	    },
	
	    verificarCategMin: function(id){	    	
	    	  var defered = $q.defer();			  
			  var data    = { idCategMin : id };			  
			  
			  $http.post(contextPath + '/contrato/transaccion/fees/verificarCategMin.action', data)
						.success(function(data) {
							defered.resolve(data);
						}).error(function(err) {
							defered.reject(err)
						});
			  return defered.promise;			
	    },
	    	    
	    validarFechasPeriodos: function(periodos){	    	
	    	var resultado = {validacion : true, mensaje: ""};
	    	
	    	for(i=1; i<periodos.length;i++){
	    	     //recorreremos todos los elementos hasta n-i, tomar en cuenta los ultimos no tiene caso ya que ya estan acomodados.
	    	     for(j=0;j<(periodos.length-i);j++){
	    	
	    	          //comparamos	    	 
	    	          if($.datepicker.parseDate('mm/dd/yy',periodos[j].fechaInicio).getTime() > 
	    	             $.datepicker.parseDate('mm/dd/yy',periodos[j+1].fechaInicio).getTime()){
	    	                //guardamos el numero mayor en el auxiliar
	    	                var aux = periodos[j];
	    	                //guardamos el numero menor en el lugar correspondiente
	    	                periodos[j] = periodos[j+1];
	    	                //asignamos el auxiliar en el lugar correspondiente
	    	                periodos[j+1]=aux;	 
	    	          }
	    	     }	
	    	}
	    			
	    	for(j=0; j<periodos.length-1;j++)
	    	{	   
	    		var fechaFin    = this.generarFechaHora(periodos[j].fechaFin).getTime();		
	    		var fechaInicio = this.generarFechaHora(periodos[j+1].fechaInicio).getTime();
	    		
	            if(fechaFin >= fechaInicio)
	    			resultado.mensaje = "El rango de fechas de los periodos debe ser excluyente.";		
	                        
	    		else if( (fechaInicio - fechaFin) != 86400000) //existe una diferencia mayor a un dia 86400000		
	    			resultado.mensaje = "Los periodos deben ser secuenciales.";				
	    	}	
	    	
	    	if(resultado.mensaje != "")
	    		resultado.validacion = false;
	    	return resultado;  			
	    },		

	    generarFechaHora: function(fecha){
	    	var fecha = $.datepicker.parseDate('mm/dd/yy', fecha);
	    	var month = fecha.getUTCMonth(); //months from 1-12
	    	var day   = fecha.getUTCDate();
	    	var year  = fecha.getUTCFullYear();	
	    	var date  = new Date(Date.UTC(year, month, day, 0, 0, 0));
	    	return date;		
	    },
	    
	    subirArchivo: function(file, url){
	    	 var defered = $q.defer();
	    	 var fd = new FormData();
	    	 fd.append('fileUpload', file);
	    	 fd.append('filename', "ej.xls");
	         	         
			 $http.post(contextPath + '/contrato/transaccion/fees/cargaArchivo.action', fd, {headers: {'Content-Type': undefined}})
						.success(function(data) {
							defered.resolve(data);
						}).error(function(err) {
							defered.reject(err)
						});
			 return defered.promise;			
	    },
	    	    
	    descargarArchivo: function(seccion, operacion, idCto, datos, encabezados){
	    	 var deferred = $q.defer();
	    	 var data     = { tipoFees : seccion, operacion:operacion, idCto:idCto, datos:datos, encabezados:encabezados };
	    	 $http.post(contextPath + '/contrato/transaccion/fees/descargar.action', data, {responseType : 'arraybuffer'})
				.success(function(data, status, headers) {
										
					headers = headers();					
					
			        var filename    = headers['content-disposition'].split(";")[1].split("=")[1];					
			        var contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
			 
			        var linkElement = document.createElement('a');
			        try {
			            var blob = new Blob([data], { type: contentType });
			            var url = window.URL.createObjectURL(blob);
			 
			            linkElement.setAttribute('href', url);
			            linkElement.setAttribute("download", filename);
			 
			            var clickEvent = new MouseEvent("click", {
			                "view": window,
			                "bubbles": true,
			                "cancelable": false
			            });
			            linkElement.dispatchEvent(clickEvent);
			        } catch (ex) {
			            console.log(ex);
			        }

					deferred.resolve(data);
				}).error(function(err) {
					showError("Se generó un error al intentar exportar el archivo de excel.");
					deferred.reject(err)
				});
	    	 return deferred.promise;			
	    }
	    	    
	  };	
};

registraService("rentaPremierService", rentaPremierService);

/*
 * 
 * 		   	//Se crean la fila para eliminar columnas
		   	tabla.columnasEliminar=[0,0,0];
		   	     
		   	for(var i=0; i<objeto.numAnios; i++)
		   	    tabla.columnasEliminar.push(1);	   		

 * 
 */