var terminosService = function($filter, $http, $q) {

	return { 
			
		obtenerTerminos: function(x){
	    	var datos;
	    	var defered = $q.defer();  
	    	$http({
	            
	    		method : "POST",
	            url : contextPath + '/contrato/transaccion/terminos/obtenerTerminos.action'
	            
	        }).then(function mySucces(response) {
	        	defered.resolve(response.data);
	        	
	        }, function myError(response) {
	            data = "error";
	        });	    	
	    	
	    	return defered.promise;
	    },
	    
		inicializarTablas: function(action){
	    	var datos;
	    	var defered = $q.defer();  
	    	$http({
	            
	    		method : "GET",
	            url : contextPath + '/contrato/transaccion/terminos/'+action+'.action'
	            
	        }).then(function mySucces(response) {
	            	        		            	       
	        	defered.resolve(response);
	        	
	        }, function myError(response) {
	            data = "error";
	        });	    	
	    	return defered.promise;
	    },
			   	    	    	    	    	    	    	    	    	   
	    crearMatriz: function(tabla){
	    	 var datos = [];
			 for(var i=0;i< tabla.datos.length;i++)
			 {
				  var fila = [];
				  for(var j=0;j< tabla.datos[0].length;j++)
				  {
					  fila[j] =  tabla.datos[i][j].valor = tabla.datos[i][j].valor != null ? tabla.datos[i][j].valor.replace(/%/g,"").replace(/,/g,"") : null;
				  
				  }  
				  datos.push(fila);
			 }		   	
	         return datos;
	    },
	    
	    crearArregloEncabezados: function(tabla){
	    	 var datos = [];
			 for(var i=0;i< tabla.encabezados.length;i++)			   			
				  datos.push(tabla.encabezados[i].valor);			 
	         return datos;
	    },
	    
	    crearMatrizMovies: function(tabla){
	    	 var datos = [];
			 for(var i=0;i< tabla.datos.length;i++)
			 {
				  var fila = [];
				  for(var j=0;j< tabla.datos[0].length;j++)
				  {
					  if(j == 0)
						 fila[j] =  tabla.datos[i][j].desc = tabla.datos[i][j].desc != null ? tabla.datos[i][j].desc.replace(/%/g,"").replace(/,/g,"") : null;
					  else
					     fila[j] =  tabla.datos[i][j].valor = tabla.datos[i][j].valor != null ? tabla.datos[i][j].valor.replace(/%/g,"").replace(/,/g,"") : null;
				  }  
				  datos.push(fila);
			 }		   	
	         return datos;
	    },
	    	    	    
	    validarTipoCambio: function(tipoCambio){	
	    	
	    	  var continuar = true;
	    	  //var tipoCambio = $("#tipoCambio").val();
	    	  
	    	  console.log(tipoCambio);
	    	  
	    	  if(!tipoCambio  || tipoCambio == "0")
			  {
				showError("Se debe seleccionar un valor para Tipo de Cambio.");
				continuar = false;
			  }
	    	  if(continuar)
	    	  {
	    		  if($("#inflacionTx").val() != "")
				  {
	    			  if(isNaN($("#inflacionTx").val()))
	    			  {
	    				  showError("El campo Inflación debe ser numerico.");
	    				  continuar = false;
	    			  }	    			  
				  }  
	    	  }
	    	  if(continuar)
	    	  {
	    		  if($("#inflacionTx").val() != "")
				  {
	    			  var infla = parseFloat($("#inflacionTx").val())
	    			  if(infla < 0 || infla > 100)
	    			  {
	    				  showError("El campo Inflación debe ser un valor entre 0 y 99.");
	    				  continuar = false;
	    			  }	    			  
				  }  
	    	  }
	    	  return continuar;
	    },
	    
	    guardar: function(data, action){	    	
	    	  var defered = $q.defer();	
	    	  
			  $http.post(contextPath + '/contrato/transaccion/terminos/'+action+'.action', data)
						.success(function(data) {
							defered.resolve(data);
						}).error(function(err) {
							showError("Error al guardar el archivo")
						});
			  return defered.promise;			
	    },
	    
	    subirArchivo: function(file, url){
	    	 var defered = $q.defer();
	    	 var fd = new FormData();
	    	 fd.append('fileUpload', file);
	    	 fd.append('filename', "ej.xls");
	         	         
			 $http.post(contextPath + '/contrato/transaccion/terminos/cargaArchivo.action', fd, {headers: {'Content-Type': undefined}})
						.success(function(data) {
							defered.resolve(data);
						}).error(function(err) {
							defered.reject(err)
						});
			 return defered.promise;			
	    },
	    	    
	    descargarArchivo: function(seccion, operacion, idCto, datos, encabezados){
	    	 var deferred = $q.defer();
	    	 var data     = { tipoFees : seccion, operacion:operacion, idCto:idCto, datos:datos, encabezados:encabezados };
	    	 $http.post(contextPath + '/contrato/transaccion/terminos/descargar.action', data, {responseType : 'arraybuffer'})
				.success(function(data, status, headers) {
										
					headers = headers();					
					
			        var filename    = headers['content-disposition'].split(";")[1].split("=")[1];					
			        var contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
			 
			        var linkElement = document.createElement('a');
			        try {
			            var blob = new Blob([data], { type: contentType });
			            var url = window.URL.createObjectURL(blob);
			 
			            linkElement.setAttribute('href', url);
			            linkElement.setAttribute("download", filename);
			 
			            var clickEvent = new MouseEvent("click", {
			                "view": window,
			                "bubbles": true,
			                "cancelable": false
			            });
			            linkElement.dispatchEvent(clickEvent);
			        } catch (ex) {
			            console.log(ex);
			        }

					deferred.resolve(data);
				}).error(function(err) {
					showError("Se generó un error al intentar exportar el archivo de excel.");
					deferred.reject(err)
				});
	    	 return deferred.promise;			
	    },

	    generaVarCarga: function(div, tipo, operacion, id){
		    uploader = new UploaderEX(div);
			uploader.tipoFees  = tipo;
			uploader.operacion = operacion;
			this.abrirModalCarga(id);
	    },
	    
	    abrirModalCarga: function(id){
		    uploader.limpiaForma("idFormCargaAlgo"+id);
			$("#esperaDiv"+id).html("");
			$("#modalImportarArchivo"+id).modal("show");
	    }
	    
	 };	
};

registraService("terminosService", terminosService);