function FormManager() {
	this.dateFormatIn  = 'yy-mm-dd';
	this.dateFormatOut = 'mm/dd/yy';
}

FormManager.prototype.limpiarForma = function(idForm ) {
	$("#" + idForm).find('input:text, input:hidden, input:password, input:file, select, textarea').val('');
	$("#" + idForm).find('input:radio, input:checkbox').removeAttr('checked').removeAttr('selected');
	$("#" + idForm).find('label.lbErrores').hide();

	var validForm = this[idForm];
	if(validForm!= null && typeof validForm != 'undefined')
		validForm.resetForm();
};

FormManager.prototype.initForm = function(idForm , opts ) {
	
	var o = {};
	if(opts != null && typeof opts != 'undefined' )
	{
		o =  $.extend(true,{}, opts);
	}
	this[idForm] = $("#" + idForm).validate(o);
};

FormManager.prototype.leerForma = function(_forma, columns) {
	var _i = {};
	var me = this;
	
	columns.forEach(function(column, i) {
		console.log(column);
	
		//se mapea columnas con campos en las formas
		var name  =  (typeof column.mname != 'undefined'  && column.mname != null ) ? column.mname : column.name;		
		
		if(name){
		var campo =  $("#" + _forma + "   [name='" + name + "']");
		
		console.log(name);
		console.log(campo);
		
		var val;
		if (campo.is(':checkbox'))
		{
			val = campo.prop('checked');
		} 							
		else if (campo.is('select')) 
		{			
			if(campo.val() != '')
			{
				val = campo.val();
				//val = {};
				//val["desc"]  = campo.find('option:selected').text();
				//val["value"] = campo.val();
			}
		} 
		else if(campo.is(':radio'))
		{
		   val = campo.filter(':checked').val();	
		} 
		else if(campo.hasClass('hasDatepicker')){
			val = campo.val();
			if (!val || $.trim(val).length === 0)
				val = null;
		}			 	
		else
		{
			val = campo.val();
		}
					
		if (val !== '') 
			me.deepSet(_i, name, val);		
	}});
	
	console.log(_i);
	console.log("");
	
	return _i;
};

FormManager.prototype.deepSet = function(obj, path, value) {
    
    var prop = path;
	if (typeof prop === "string")
		prop = prop.split(".");

	if (prop.length > 1) 
	{
		var e = prop.shift();
		Object.assign(obj[e] = Object.prototype.toString.call(obj[e]) === "[object Object]" ? obj[e] : {}, prop, value);
	} 
	else 
	{
		obj[prop[0]] = value;
	}
};

FormManager.prototype.llenarForma = function(t,_forma,columns) {	
	var me = this;

	console.log(t)
	
	columns.forEach(function(column, i) {
		var name  =  (typeof column.mname != 'undefined'  && column.mname != null ) ? column.mname : column.name;
		var _item = $("#" + _forma + " [name='" + name + "']");
		var value = t[name];
		
		console.log(name)
		console.log(_item)
		console.log(value)
		
		if (_item.is(':checkbox')) 
		{
			_item.prop('checked', value);
		}
		else if (_item.is('select')) 
		{
			if( typeof value != 'undefined'  && value != null )
			{				
				$(_item).find("option").each(function()
				{		
					if($(this).text() == value)
				       _item.val($(this).val());						
				});				
			}			
		}
		else if(_item.is(':radio'))
		{
			_item.filter("[value='"+value+"']" ).prop('checked', true);
		}
		else 
		{
			_item.val(value);
		}
		
		console.log(_item)
		
		$(_item).trigger("change");
	});
};


FormManager.prototype.mapCheckToRadio = function(checkNamesList, radioName, _titulo, _forma) {
	if(checkNamesList)
	   for(var i=0; i<checkNamesList.length; i++){
		   var valorCheck = _titulo[checkNamesList[i]];
			if (valorCheck){
				var _item = $("#" + _forma + " [name='" + radioName + "']");
				if(_item.is(':radio'))
					_item.filter("[id='" + checkNamesList[i] + "']" ).prop('checked', true);
				$(_item).trigger("change");
			} 
	   }
};

FormManager.prototype.mapRadioToCheck = function(radioName, checkNamesList, _titulo, _forma) {
	var me = this;
	
	console.log("mapRadioToCheck");
	var valorRadio = $("input:radio[name='" + radioName + "']:checked").attr('id');

	for(var i=0; i<checkNamesList.length; i++){
		var checkValor = false;
		if(checkNamesList[i] == valorRadio)
			checkValor = true;
		me.deepSet(_titulo, checkNamesList[i], checkValor);		
	}
	
	console.log(_titulo);
};

/*
FormManager.prototype.changeDateFormat = function (formatIn,formatOut,value)
{
	var _value = value;
	if(value != null  && value != "" && typeof value != 'undefined'){
    	_value = value.split("T")[0];
		var d = $.datepicker.parseDate( formatIn, _value ); 
		
		d = new Date(d.valueOf() + d.getTimezoneOffset() * 60000);
		_value = $.datepicker.formatDate(formatOut,d);
	}
	return _value;
};
*/