var perfil;

$(document).ready(function() {

	perfil = new PerfilController();
	inicializarBotones();
	inicializarCatalogo();
	perfil.ejecutarPerfil(parseInt($("#pmn").val()));

});

function inicializarCatalogo() {
	$.post(contextPath + '/ncredito/listado/obtenerEstudiosListado').done(
			function(response) {
				if (response.msgError != null) {
					showError(response.msgError);
				} else {
					$('#seleccionEstudio').append(
							'<option value="0">Todos</option>');
					for (var i = 0; i < response.estudios.length; i++) {
						var valor = response.estudios[i].idEstudio;
						var texto = response.estudios[i].descripcionEstudio;
						var opcion = '<option value="' + valor + '">' + texto
								+ '</option>';
						$('#seleccionEstudio').append(opcion);
					}
				}
			});
}

function inicializarBotones() {

	$("#buscar").click(function() {
		realizaBusquedaNotasCredito();
	});

	$("#nuevo").click(function() {
		realizaOperacionNotaCredito(1, 0);
	});

	$('#nuevo').prop("disabled", true);
}

function realizaBusquedaNotasCredito() {
	var estudio = null;
	var estudios = [];
	var estudioEleccion = $("#seleccionEstudio").val();
	var numeroFactura = null;
	var i = 0;

	if (estudioEleccion == "0") {

		$("#seleccionEstudio option").each(function() {
			estudio = {
				idEstudio : $(this).val(),
				descripcionEstudio : ""
			}
			estudios[i] = estudio;
			i++;
		});
	} else {
		estudio = {
			idEstudio : estudioEleccion,
			descripcionEstudio : ""
		}
		estudios[i] = estudio;
	}

	if ($("#numeroFactura").val() !== "")
		numeroFactura = $("#numeroFactura").val();

	$.post(contextPath + '/ncredito/listado/obtenerNotasCreditoListado', {
		jsonRequest : JSON.stringify(estudios),
		numeroFactura : numeroFactura
	}).done(
			function(response) {

				if (response.msgError != null) {
					showError(response.msgError);
				} else {
					var contenedor = "contenedor";
					var nombretabla = "listadoNotasCredito";

					$('#' + contenedor).empty();
					$('#' + nombretabla).remove();

					generaTablaListadoNotasCredito(contenedor, nombretabla,
							response.listadoNotasCredito);
				}
			});
}

function generaTablaListadoNotasCredito(contenedor, nombreTabla,
		listaNotasCredito) {

	var notasCredito = [];
	for (var i = 0; i < listaNotasCredito.length; i++) {
		var notaCredito = [];
		notaCredito[0] = listaNotasCredito[i].numeroFactura;
		notaCredito[1] = listaNotasCredito[i].descEstudio;
		notaCredito[2] = listaNotasCredito[i].fechaFactura;
		notaCredito[3] = listaNotasCredito[i].approved;
		notaCredito[4] = listaNotasCredito[i].idSapRegistro;
		notaCredito[5] = listaNotasCredito[i].monto;
		notaCredito[6] = listaNotasCredito[i].acciones;
		notaCredito[7] = listaNotasCredito[i].idNota;
		notasCredito[i] = notaCredito;
	}

	$("#" + contenedor).append(
			$("<table/>").addClass('table table-striped table-hover').attr(
					'id', nombreTabla));
	$("#" + nombreTabla).append($("<thead/>").addClass('encabezado'));

	var table = $('#' + nombreTabla)
			.DataTable(
					{
						data : notasCredito,
						columns : [ {
							title : "N\u00FAmero"
						}, {
							title : "Estudio"
						}, {
							title : "Fecha"
						}, {
							title : "Approved"
						}, {
							title : "SAP"
						}, {
							title : "Amount"
						}, {
							title : "Acciones"
						} ],
						columnDefs : [ {
							"targets" : -1,
							"data" : null,
							"defaultContent" : ""
						} ],
						createdRow : function(row, data, index) {

							$('td', row).eq(3).empty();
							$('td', row).eq(4).empty();

							var html;

							html = agregarIconCheck(data[3]);
							$('td', row).eq(3).append(html);

							html = agregarIconCheck(data[4]);
							$('td', row).eq(4).append(html);

							if (data[3] == "1")
								$('td', row)
										.eq(6)
										.append(
												"<a href='#' onclick='realizaOperacionNotaCredito(3,"
														+ data[7]
														+ ")' style='color:#CB2C25'>Ver</a>");
							else
								$('td', row)
										.eq(6)
										.append(
												"<a href='#' onclick='realizaOperacionNotaCredito(2,"
														+ data[7]
														+ ")' style='color:#CB2C25'>Editar</a>  "
														+ "<a href='#' onclick='realizaOperacionNotaCredito(4,"
														+ data[7]
														+ ")' style='color:#CB2C25'>Eliminar</a>");

							console.log(row);
							console.log(data);
							console.log(data[3]);
						},
						language : {
							"sProcessing" : "Procesando...",
							"sLengthMenu" : "Mostrar _MENU_ registros",
							"sZeroRecords" : "No se encontraron resultados",
							"sEmptyTable" : "No hay contratos que satisfagan los criterios de b\u00FAsqueda.",
							"sInfo" : "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
							"sInfoEmpty" : "Mostrando registros del 0 al 0 de un total de 0 registros",
							"sInfoFiltered" : "(filtrado de un total de _MAX_ registros)",
							"sInfoPostFix" : "",
							"oPaginate" : {
								"sFirst" : "Primero",
								"sLast" : "Último",
								"sNext" : "Siguiente",
								"sPrevious" : "Anterior"
							},
						},
						bFilter : false,
						bInfo : false,
						"bSort" : false,
						scrollX : true
					});
	table.columns.adjust().draw();

	$('table tbody tr').find("td:nth-child(7)").find("a:first").hide();
	$('table tbody tr').find("td:nth-child(7)").find("a:last").hide();
	perfil.ejecutarPerfil(parseInt($("#pmn").val()));
}

function agregarIconCheck(valor) {
	html = "";
	if (valor == "1")
		html = "<i class='fa fa-check'>";
	return html;
}

function realizaOperacionNotaCredito(idOperacion, idNotaCredito) {

	// var idNotaCredito = notaCreditoId;
	var pmn = 171;
	if (idOperacion == "1" || idOperacion == "2" || idOperacion == "3") // 1
																		// agregar,
																		// 2
																		// editar,
																		// 3 ver
	{
		pmn = idOperacion == "2" ? 172 : 171;
		var urlAction = contextPath
				+ '/ncredito/listado/operarSobreNotaCredito?idOperacion='
				+ idOperacion + '&idNotaCredito=' + idNotaCredito + "&pmn="
				+ pmn + "&pmnReturn=" + 170;
		window.location.href = urlAction;
	} else if (idOperacion == "4") {
		$.post(contextPath + '/ncredito/listado/operarSobreNotaCredito', {
			idNotaCredito : idNotaCredito,
			idOperacion : idOperacion
		}).done(function(response) {
			if (response.msgError != null)
				showError(response.msgError);
			else {
				showMessage(response.msgExito);
				realizaBusquedaNotasCredito();
			}
		});
	}
}