<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<div class="row">
	<div class="col-md-2">
		<c:if test="${fn:length(justificaciones)>0 }">
				<fmt:formatDate pattern='MM/dd/yyyy'   value='${justificaciones[0].fecha}' />
			</c:if>
	</div>
	<div class="col-md-2">
		<c:if test="${fn:length(justificaciones)>0 }">
				${justificaciones[0].usuario.nombre} ${justificaciones[0].usuario.paterno} ${justificaciones[0].usuario.materno} 
			</c:if>
	</div>
	<div class="col-md-6">
		<c:if test="${fn:length(justificaciones)>0 }">
				${justificaciones[0].justificacion}
			</c:if>
	</div>
	<div class="col-md-2">
		<ul class="nav nav-pills">
			<li><a role="button" data-toggle="modal" data-target="#myModalJ">Ver todas <span class="badge">${fn:length(justificaciones)}</span>
			</a></li>
		</ul>
	</div>
</div>



<!-- Modal -->
<div class="modal fade bs-example-modal-lg" id="myModalJ">
	<div class="modal-dialog  modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"
					aria-hidden="true"></button>
				<h4 class="modal-title">Justificaciones</h4>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="col-md-2">
						<h5>Fecha</h5>
					</div>
					<div class="col-md-2">
						<h5>Nombre</h5>
					</div>
					<div class="col-md-8">
						<h5>Justificacion</h5>
					</div>
				</div>
				<hr>
				<c:forEach var="m" items="${justificaciones}">
					<div class="row">
						<div class="col-md-2"><fmt:formatDate pattern='MM/dd/yyyy'   value='${m.fecha }' /></div>
						<div class="col-md-2">${m.usuario.nombre} ${m.usuario.paterno} ${m.usuario.materno}</div>
						<div class="col-md-8">${m.justificacion}</div>
					</div>
					<hr>
				</c:forEach>
				<!-- Pide este div para que no se descuadre el modal :S -->
				<div class="form-group"></div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			</div>
		</div>
	</div>
</div>


