package com.mx.dla.dda.contrato.minimoseleccion.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.contrato.fees.dtos.FeesSuscriptorBD;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.AnnioDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoMinimoSeleccionDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoCategoriaDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoCostoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoFlatDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.DetalleAnnioPeriodoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.MontoRealDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.PeriodoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.SuscriptoresPeriodoDTO;

public interface MinimoSeleccionDAO {
	
	//public List<PeridoPagoDTO> obtenPeriodoPago(@Param("idContrato") Long idContrato);
	
	public void cambiaMinimoCategoria(@Param("idPagoCategoria") Long idPagoCategoria, @Param("minimoSeleccion") String minimoSeleccion);
	
	public Long obtenerEstatusContrato(@Param("idContrato") Long idContrato);
	
	public void cambiaMontoPeriodo (@Param("idMonto") Long idMonto, @Param("montoMinimo") String montoMinimo);
	
	public String obtenTipoPago(@Param("idContrato") Long idContrato);
	
	public List<AnnioDTO> obtenAnnioContrato(@Param("idContrato") Long idContrato);
	
	public List<PeriodoDTO> obtnePeriodoContrato(@Param("idContrato") Long idContrato);
	
	public List<DetalleAnnioPeriodoDTO> obtenAnnioCategorias(@Param("idContratoPago") Long idContratoPago, @Param("annio") Integer annio);
	
	public List<DetalleAnnioPeriodoDTO> obtenPeriodoCategorias(@Param("idContratoPago") Long idContratoPago);
	
	public String obtenAnnioMinimoMonto(@Param("idContratoPago") Long idContratoPago, @Param("annio") Integer annio);
	
	public String obtenPeriodoMinimoMonto(@Param("idContratoPago") Long idContratoPago);
	
	public void actualizaMinimoMontoAnnio(@Param("idContratoPago") Long idContratoPago, @Param("minimoMonto") String minimoMonto, @Param("annio") Integer annio);
	
	public void actualizaMinimoMontoPeriodo(@Param("idContratoPago") Long idContratoPago, @Param("minimoMonto") String minimoMonto);
	
	public void actualizaMinimoTitulos(@Param("minimoMonto") String minimoMonto, @Param("idMinimoSeleccion") Long idMinimoSeleccion);
	
	public String obtenCostoAnnio(@Param("idContratoPago") Long idContratoPago, @Param("idPagoCategoria") Long idPagoCategoria, @Param("annio") Integer annio);
	
	public String obtenCostoPeriodo(@Param("idContratoPago") Long idContratoPago, @Param("idPagoCategoria") Long idPagoCategoria, @Param("suscriptores") Integer suscriptores);
		
	public void guardarminSeleccionCtoPago(@Param("idSelMin")Long idSelMin, @Param("idContratoPago")Long id, @Param("anio")Long anio);
	
	public void guardarminSeleccionCtoPagoCateg(@Param("idSelMin")Long idSelMin, @Param("idContratoPago")Long id, @Param("idCategoria")Long idCatsPago, @Param("anio")Long anio);
	
	public void eliminarminSeleccionCtoPago(@Param("idContratoPago")Long id);
	
	public void eliminarMinSeleccionXCto(Long idContrato);
	
	public void eliminarminSeleccionCtoPagoCateg(@Param("idContratoPago")Long id, @Param("idCategoria")Long idCategoria);
	
	public void guardarMinSeleccionXAnio(@Param("minSelAnio")List<FeesSuscriptorBD> minSelAnio);
	
	public void guardarMinSeleccionXCatAnio(@Param("minSelAnio")List<FeesSuscriptorBD> minSel);
	
	public Long getSecuenciaSeleccion();

	public String obtneFechaInicioPeriodo(@Param("idContrato") Long idContrato, @Param("idContratoPago") Long idContratoPago);
	
	
    //	Minimos Selecccion V2.  	
	public List<ContratoPagoDTO> consultaPeriodosPagoContrato(@Param("idContrato")Long idContrato);
	public List<ContratoPagoCategoriaDTO> consultaCategoriasPagoContrato(@Param("idContrato")Long idContrato);
	public List<ContratoMinimoSeleccionDTO> consultaMinimosSeleccionContrato (@Param("idContrato")Long idContrato);
	public List<ContratoPagoFlatDTO> consultaContratoPagoFlat(@Param("idContrato")Long idContrato);
	public List<ContratoPagoCostoDTO> consultaContratoPagoCosto(@Param("idContrato")Long idContrato);
	public void actualizaMinimoMonto(@Param("idContratoPago") Long idContratoPago, @Param("idPagoCategoria") Long idPagoCategoria, @Param("annio") Integer annio, @Param("minimoMonto") String minimoMonto);
	public List<AnnioDTO> obtenAnniosPeriodoPorContrato(@Param("idContrato") Long idContrato);
	
	//public List<ContratoMinimoSeleccionDTO> consultaMinimosPeriodoAnio (@Param("idContratoPago") Long idContratoPago, @Param("annio") Integer annio);
	//public List<ContratoMinimoSeleccionDTO> consultaTotalMinimosPeriodoAnio (@Param("idContratoPago") Long idContratoPago, @Param("annio") Integer annio);
	//	Fin Minimos Selecccion V2.  
	
	//
	
	public List<MontoRealDTO> obtenInformacionMontoReal(@Param("idContrato")Long idContrato);
	public List<SuscriptoresPeriodoDTO> obtnerSuscriptoresPeriodo(@Param("idContrato")Long idContrato);
	
	
	

}
