package com.mx.dla.dda.contrato.transaccion.fees.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.catalogos.dtos.FormatoDTO;
import com.mx.dla.dda.contrato.transaccion.catalagos.dtos.TipoCambioTDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTImpuestoDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTMinValoresDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTMinimoDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTPrecioDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTRevenueDTO;

public interface FeesTransaccionDAO {
	
	public List<FeesTMinimoDTO>     obtenerMinimosPremier  (Long idContrato);		
	public List<FeesTMinValoresDTO> obtenerMinimosAnioValoresPremier(Long idContrato);
	public List<FeesTMinimoDTO>     obtenerReleasePremier  (Long idContrato);
	public List<FeesTImpuestoDTO>   obtenerPaisesPremier   (Long idContrato);
	public List<FeesTImpuestoDTO>   obtenerImpuestosPremier(Long idContrato);
	public List<FeesTRevenueDTO>    obtenerRevenuePremier  (Long idContrato);
	public List<FeesTPrecioDTO>     obtenerPrecioPremier   (Long idContrato);
	public List<Integer>            obtenerNumRegPrecios   (Long idContrato);
	public List<String>             obtenerFormatos();
	public List<FormatoDTO>         getFormatos();
	public List<TipoCambioTDTO>     getTipoCambio();
	public Integer                  obtenerTipoCambio(Long idContrato);
	public List<String> obtenerSeccionMinimos        (Long idContrato);
    public List<String> obtenerSeccionAnio           (Long idContrato);	
	
	public List<FeesTMinimoDTO>     obtenerMinimosLibreria  (Long idContrato);
	public List<FeesTMinimoDTO>     obtenerMinimosLibreriaRevenue (Long idContrato);
	public List<FeesTMinValoresDTO> obtenerMinimosAnioValoresLibreria(Long idContrato);	
	public List<FeesTImpuestoDTO>   obtenerImpuestosLibreria(Long idContrato);
	public List<FeesTPrecioDTO>     obtenerPrecioLibreria   (Long idContrato);	
	public FeesTRevenueDTO          obtenerRevenueGlobalLiberia (Long idContrato);
	public List<FeesTRevenueDTO>    obtenerRevenueBoxLibreria   (Long idContrato);	
	
	
	public List<FeesTMinimoDTO>     obtenerMinimosEst           (Long idContrato);		
	public List<FeesTMinValoresDTO> obtenerMinimosAnioValoresEst(Long idContrato);	
	public List<FeesTImpuestoDTO>   obtenerImpuestosEst         (Long idContrato);
	public List<FormatoDTO>             obtenerTiers();
	public List<FeesTPrecioDTO>     obtenerPrecioMovies        (Long idContrato);
	public List<Integer>            obtenerNumRegPreciosMovies (Long idContrato);
	public List<FeesTRevenueDTO>    obtenerRevenueMovies       (Long idContrato);
	
	public List<FormatoDTO>             obtenerCatSeries();
	public List<FeesTPrecioDTO>     obtenerPrecioSeries       (Long idContrato);
	public List<Integer>            obtenerNumRegPreciosSeries(Long idContrato);
	public List<FeesTRevenueDTO>    obtenerRevenueSeries      (Long idContrato);

	//CONSULTAS para las operacion de aguardar y actualizar
	public void guardarCatMinTrans        (@Param("categoria") FeesTMinimoDTO categoria, @Param("idContrato") Long idContrato);
	public void editarCatMinTrans         (@Param("categoria") FeesTMinimoDTO categoria);
	public void eliminarValorCatMinTrans  (@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void eliminarCatMinTrans       (@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void guardarValoresCatMin      (@Param("valores") List<FeesTMinValoresDTO> valores);
	public void eliminarValorAnnioMinTrans(@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void guardarValoresAnnioMin    (@Param("valores") List<FeesTMinValoresDTO> valores,  @Param("idContrato") Long idContrato);

	public void eliminarValoresImpuesto   (@Param("idContrato")Long idContrato, @Param("seccion")String seccion);
	public void guardarValoresImpuesto    (@Param("impuestos")List<FeesTImpuestoDTO> impuestos, @Param("idContrato") Long idContrato);
	
	public void guardarValoresReleasePremier(@Param("release")FeesTMinimoDTO release, @Param("idContrato") Long idContrato);
	public void editarValoresReleasePremier (@Param("release")FeesTMinimoDTO release);
	
	public void eliminarValoresPrecioPremier();
	public void guardarValoresPrecioPremier (@Param("precios")List<FeesTPrecioDTO> precios, @Param("idContrato")Long idContrato);
	
	public void eliminarValoresRevenuePremier(@Param("idContrato") Long idContrato);
	public void guardarValoresRevenuePremier (@Param("revenues")List<FeesTRevenueDTO> revenues, @Param("idContrato") Long idContrato);
	
	public void eliminarValoresPrecioLibreria(@Param("idContrato") Long idContrato);
	public void guardarValoresPrecioLibreria (@Param("precios")List<FeesTPrecioDTO> precios, @Param("idContrato") Long idContrato);
	
	public void eliminarValoresPrecioMovies(@Param("idContrato") Long idContrato);
	public void guardarValoresPrecioMovies (@Param("precios")List<FeesTPrecioDTO>  precios, @Param("idContrato") Long idContrato);
	
	public void eliminarValoresPrecioSeries(@Param("idContrato") Long idContrato);
	public void guardarValoresPrecioSeries (@Param("precios")List<FeesTPrecioDTO>  precios, @Param("idContrato") Long idContrato);
	
	
	public void eliminarValoresRevenueMovies(@Param("idContrato") Long idContrato);
	public void guardarValoresRevenueMovies (@Param("revenues")List<FeesTRevenueDTO> revenues, @Param("idContrato") Long idContrato);
	
	public void eliminarValoresRevenueSeries(@Param("idContrato") Long idContrato);
	public void guardarValoresRevenueSeries (@Param("revenues")List<FeesTRevenueDTO> revenues, @Param("idContrato") Long idContrato);
	
	public void eliminarCategMinimos   (@Param("ids") Long[] ids);
	public void eliminarCategValMinimos(@Param("ids") Long[] ids);	
	
	public void eliminarCategRevenueXRelease(@Param("ids") Long[] ids);
	public void eliminarCategPrecioxRelease (@Param("ids") Long[] ids);
	public void eliminarCategReleaseXRelease(@Param("ids") Long[] ids);
	
	
	public void eliminarRevBoxLibreria(Long idContrato);
	public void guardarRevenueBox     (@Param("revenues") List<FeesTRevenueDTO> revenues);

	public void guardarRevenueGlobal  (@Param("idContrato") Long idContrato, @Param("revenue")FeesTRevenueDTO revenue);
	public void eliminarRevenueGlobal(Long idContrato);

	public void guardarTipoCambio(@Param("idContrato") Long idContrato, @Param("idTipo")Long idTipo);
	public void eliminarTipoCambio(@Param("idContrato") Long idContrato);
}
