package com.mx.dla.dda.contrato.transaccion.titulos.daos;

import java.util.Date;
import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.transaccion.titulos.dtos.TituloTransDB;
import com.mx.dla.dda.contrato.transaccion.titulos.dtos.TituloTransaccionDTO;
import com.mx.dla.dda.contrato.transaccion.titulos.dtos.TituloTransaccionExcel;

@Component
public interface TituloTransDAO {

	public void guardarTituloTrans(@Param("titulo") TituloTransDB titulo);
	public void editarTituloTrans (@Param("titulo") TituloTransDB titulo);
	public void eliminarTitulo    (Long idTitulo);
			
	public void actualizarCategoriaTrans
	            (@Param("idCategoria")Long idCategoria, @Param("idTituloCnt")Long idTituloCnt, @Param("bloque") Boolean bloque, @Param("ids") List<Long> ids);

	public void actualizarVentanaTrans  
	            (@Param("fechaInicio")Date fechaInicio, @Param("fechaFin")Date fechaFin, @Param("idTituloCnt")Long idTituloCnt, @Param("bloque")Boolean bloque, @Param("ids")List<Long> ids);
	
	public void actualziarDTRTrans      
	            (@Param("categoriaDTR") String categoriaDTR, @Param("idTituloCnt") Long idTituloCnt, @Param("bloque") Boolean bloque, @Param("ids") List<Long> ids);
	
	public void actualizarHvrdTrans     
	            (@Param("hvrd") Date hvrd, @Param("idTituloCnt") Long idTituloCnt, @Param("bloque") Boolean bloque, @Param("ids") List<Long> ids);
	
	public void actualziarDTOTrans      
    			(@Param("idTier")Long idTier, @Param("idCats")Long idCats, @Param("idTituloCnt") Long idTituloCnt, @Param("bloque") Boolean bloque, @Param("ids") List<Long> ids);
	
	public Integer contarTitulosDTR(@Param("ids") List<Long> ids);
	
	public List<TituloTransDB> buscaTotalesListaTran    (@Param("prefix") String prefix, @Param("idLista") Long idLista);
	public List<TituloTransDB> buscaDetallePeliculasTran(@Param("idLista") Long idLista);
	
	public void borrarTitulo(Long idContrato);
	
	public List<CatalogoDTO> obtenerFiliales  (Long idContrato);
	public List<CatalogoDTO> obtenerCatSeries ();
	public List<CatalogoDTO> obtenerTiers     ();
	public List<CatalogoDTO> obtenerGeneros   ();
	public List<CatalogoDTO> obtenerCategorias(Long idContrato);
	
	public Integer buscarTitulosPorDescripcionEnLista
	               (@Param("idLista")Long idLista, @Param("idTitulo")Long idTiulo, @Param("nombre")String nombre, @Param("temporada")String temporada, @Param("episodio")String episodio);	
	
	public Integer buscarTitulosOtrosContratosXBV
	               (@Param("fechaInicio")Date fechaInicio, @Param("fechaFin")Date fechaFin, @Param("idBV")String idBV, @Param("idLista")Long idLista);
	
	public Integer buscarTitulosListaXBV       
	               (@Param("fechaInicio")Date fechaInicio, @Param("fechaFin")Date fechaFin, @Param("idBV")String idBV, @Param("idLista")Long idLista, @Param("idTitulo")Long idTitulo);

	public List<TituloTransaccionExcel> obtenerTitulosExcel(Long idLista);
	
	public Lista             buscarListaActual              (@Param("idContrato")Long idContrato, @Param("prefix") String prefix);
	public List<Lista>       buscarListasPorContratoCreacion(@Param("idContrato")Long idContrato, @Param("prefix") String prefix);	
	public List<CatalogoDTO> buscarCatListaByContrato       (@Param("idContrato")Long idContrato, @Param("prefix") String prefix);
	public void              insertarLista                  (@Param("lista")Lista lista, @Param("prefix") String prefix, @Param("idContrato")Long idContrato, @Param("fechaInicio")Date fechaInicio);
	public void              actualizarFechaFinLista        (@Param("idLista")Long lista, @Param("prefix") String prefix, @Param("fechaFin")Date fechaFin);
	public List<Long>        buscarListaValidas             (@Param("idContrato")Long idContrato, @Param("prefix") String prefix);
	
	
	public List<TituloTransaccionExcel> obtenerTitulosExcelError(Long idCarga);
	
	
	public List<TituloTransDB> buscaTotalesSerie(@Param("idLista")Long idLista, @Param("nombreUnico") String nombreUnico , @Param("prefix") String prefix);
	public List<TituloTransDB> buscaDetalleSeriesTran(@Param("idLista")Long idLista, @Param("nombreUnico") String nombreUnico);	
	public List<TituloTransDB> buscaSeries1CapituloTrans(@Param("idLista")Long idLista, @Param("prefix") String prefix);
	
	public Integer findSerieSeasonTrans(@Param("nombre")String nombre, @Param("temporada") String temporada);
	public Integer findCategoriaTrans(@Param("categoria") String categoria);
	
	public Integer obtenerNumTitulos(@Param("idContrato") Long idContrato);
	
	public Integer verificarTituloVentana(@Param("fechaInicio")Date fechaInicio, @Param("fechaFin")Date fechaFin, @Param("nombreUnico")String nombreUnico);
	
	public List<TituloTransDB> titulosVentanaEnNoTransaccionales(@Param("titulo")TituloTransaccionDTO titulo, @Param("contrato")ContratoDTO contrato);
	public List<TituloTransDB> titulosVentanaEnTransaccionales(@Param("titulo")TituloTransaccionDTO titulo, @Param("contrato")ContratoDTO contrato);
	public List<TituloTransDB> titulosVentanaEnContrato(@Param("titulo")TituloTransaccionDTO titulo, @Param("contrato")ContratoDTO contrato, @Param("prefix") String prefix);
	
	public List<TituloTransDB> listaTitulosDetalle(@Param("titulo")TituloTransaccionDTO titulo);
	public List<TituloTransDB> listaTitulosSeries(@Param("titulo")TituloTransaccionDTO titulo, @Param("uso")String uso);
	public List<TituloTransDB> listaTitulosPrincipal(@Param("titulo")TituloTransaccionDTO titulo, @Param("uso")String uso);
	
	public List<TituloTransDB> obtenTitulos(@Param("ids") List<Long> ids, @Param("listas") List<Long> listas, @Param("prefix") String prefix);
	
}
