package com.mx.dla.dda.admin.presupuesto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.Test;

import com.mx.dla.dda.admin.presupuestos.daos.PresupuestoDAO;
import com.mx.dla.dda.admin.presupuestos.dtos.AmortApartadoDTO;
import com.mx.dla.dda.admin.presupuestos.dtos.PresupuestoApartadoDTO;
import com.mx.dla.dda.admin.presupuestos.dtos.PresupuestoDTO;
import com.mx.dla.dda.common.test.BaseDaoTest;


public class PresupuestoTest  extends BaseDaoTest{
	
	@Autowired
	private PresupuestoDAO presupuestoDAO;
		
	@Test(enabled = false)
	public void getPresupuestosDAO(){
		List<Long> l = new ArrayList<Long>();
		l.add(51L);
		List<PresupuestoDTO> pre = presupuestoDAO.getPresupuestos(l);
		logger.debug(pre.toString());
	}
			
	@Test(enabled = false)
	public void getAmortizaciones(){
		List<Long> ids = new ArrayList<Long>();
		ids.add(92L);
		
		List<AmortApartadoDTO> amortizacion = presupuestoDAO.getApartadosAmortizacion(ids);
				 
		logger.debug(""+amortizacion.size());
		logger.debug(""+amortizacion.get(0).getId()  + amortizacion.get(0).getAnio());
	}
	
	@Test(enabled = false)
	public void guardarApartado(){
		PresupuestoApartadoDTO p = new PresupuestoApartadoDTO();
		p.setMontoAsignado(20000.0);
		p.setFechaSAP(new Date());
		p.setId(94L);
		
		presupuestoDAO.guardarApartado(p, 2016);
		logger.debug(""+p.toString());
	}
	
	@Test(enabled = false)
	public void editarApartado(){
		PresupuestoApartadoDTO p = new PresupuestoApartadoDTO();
		p.setMontoAsignado(30000.0);
		p.setFechaSAP(null);
		p.setId(92L);
		p.setIdPreApart(298L);
		
		presupuestoDAO.actualizarApartado(p);
		logger.debug(""+p.toString());
	}
				
	@Test(enabled = false)
	public void obtenerApartadosAsignado() throws Exception{
		List<PresupuestoApartadoDTO> pto = presupuestoDAO.getApartadosXTipo("Amortizable");
		logger.debug(pto.toString());
	}
	
	@Test(enabled = false)
	public void getAmortizable() throws Exception{
		String pto = presupuestoDAO.getAmortizable(2017);
		logger.debug(pto.toString());
	}
	
}
