package com.mx.dla.dda.admin.catalogos.addons.bos;

import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.admin.catalogos.addons.daos.CatalogoAddOnsDAO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.CatalogoAddOnDTO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.RelacionAddOnDTO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.dtos.PaisAddOnsVDTO;
import com.mx.dla.global.bos.BaseBO;

@Service
public class AddOnBO extends BaseBO{

	@Autowired
	private CatalogoAddOnsDAO catalogoAddOnsDAO;
	
	public List<CatalogoAddOnDTO>catalogoAddOns(){
		return catalogoAddOnsDAO.catalogoAddOns();
	}
	
	public void updateAddOn(CatalogoAddOnDTO addOn){
		catalogoAddOnsDAO.updateAddOn(addOn);
	}
	
	public CatalogoAddOnDTO guardarAddOn(Integer idAddOn, Integer idEstudio, String pais, Integer revenueShare, 
			Double precio, Double vat, Double precioNeto, Double vatFijo, Double precioNetoFijo, String tipoCambio, String calculoMontoXPais, 
			String calculoRevenueShare, Double tarifaMinima, String preferido){
		Long idRelacion = null; 
		
		idRelacion = catalogoAddOnsDAO.obtenerIdRelacion(Long.valueOf(String.valueOf(idEstudio)), Long.valueOf(pais));
		
		// Si la Relacion NO EXISTE, entonces se crea.
		if(idRelacion == null){
			RelacionAddOnDTO relacion = new RelacionAddOnDTO();
			relacion.setIdEstudio(Long.valueOf(String.valueOf(idEstudio)));
			relacion.setIdPaisAddOn(Long.valueOf(pais));
			relacion.setEstatus(1l);
			
			catalogoAddOnsDAO.crearNuevaRelacion(relacion);
			idRelacion = catalogoAddOnsDAO.obtenerIdRelacion(Long.valueOf(String.valueOf(idEstudio)), Long.valueOf(pais));
		}
		
		CatalogoAddOnDTO addOnNuevo = new CatalogoAddOnDTO();
		addOnNuevo.setIdAddOn(idAddOn);
		addOnNuevo.setIdRelacion(idRelacion);
		addOnNuevo.setRevenueShare(revenueShare);
		addOnNuevo.setPrecio(precio);
		addOnNuevo.setVat(vat);
		addOnNuevo.setPrecioNeto(precioNeto);
		addOnNuevo.setTipoDeCambio(tipoCambio);
		addOnNuevo.setCalculoMontoXPais(calculoMontoXPais);
		addOnNuevo.setCalculoRevenueShare(calculoRevenueShare);
		addOnNuevo.setTarifaMinima(tarifaMinima);
		addOnNuevo.setPreferido(preferido);
		addOnNuevo.setVatFijo(vatFijo);
		addOnNuevo.setPrecioNetoFijo(precioNetoFijo);
		
		if(preferido.equals("1")){
			catalogoAddOnsDAO.actualizaPreferidoAddOn(addOnNuevo);
		} else {
			Long num = catalogoAddOnsDAO.numeroRelaciones(idRelacion.intValue());
			if(num == 0) {
				addOnNuevo.setPreferido("1");
			}
		}
		
		try{
			catalogoAddOnsDAO.guardarAddOn(addOnNuevo);
		}catch(DuplicateKeyException ex){
			System.out.println(ex.getMessage());
			throw new DuplicateKeyException("PK");
		
		}catch (Exception e) {
			System.out.println(e.getMessage());
		}
		
		return addOnNuevo;
	}
	
	public CatalogoAddOnDTO catalogoAddOnsPorId(Integer idAddOn){
		 CatalogoAddOnDTO addOn = catalogoAddOnsDAO.catalogoAddOnsPorId(idAddOn);
		 logger.debug("Busca addOn");
		 return addOn;
	}
	
	public List<PaisAddOnsVDTO> obtenerPaisesAddOn(){
		 return catalogoAddOnsDAO.obtenerPaisesAddOn();
	}
	
	public void actulizaCatalogoAddOn(Integer idAddOn, Integer idEstudio, String pais, Integer revenueShare, Double precio, 
			Double vat, Double precioNeto, Double vatFijo, Double precioNetoFijo, String tipoCambio, String calculoMontoXPais, String calculoRevenueShare, 
			Double tarifaMinima, String preferido){		
		logger.debug("[{}]", idAddOn);
		
		Long idRelacion = catalogoAddOnsDAO.obtenerIdRelacion(Long.valueOf(String.valueOf(idEstudio)), Long.valueOf(pais));
		
		CatalogoAddOnDTO addOn = new CatalogoAddOnDTO();
		addOn.setIdAddOn(idAddOn);
		addOn.setIdRelacion(idRelacion);
		addOn.setRevenueShare(revenueShare);
		addOn.setPrecio(precio);
		addOn.setVat(vat);
		addOn.setPrecioNeto(precioNeto);
		addOn.setTipoDeCambio(tipoCambio);
		addOn.setCalculoMontoXPais(calculoMontoXPais);
		addOn.setCalculoRevenueShare(calculoRevenueShare);
		addOn.setTarifaMinima(tarifaMinima);
		addOn.setPreferido(preferido);
		addOn.setVatFijo(vatFijo);
		addOn.setPrecioNetoFijo(precioNetoFijo);
		
		if(preferido.equals("1")){
			catalogoAddOnsDAO.actualizaPreferidoAddOn(addOn);
		}
		
		catalogoAddOnsDAO.actualizaAddOn(addOn);
		
		if(preferido.equals("0")) {
			Long num = catalogoAddOnsDAO.numeroRelacionesPreferidas(revenueShare, "1");
			if (num == 0) {
				addOn.setPreferido("1");
				catalogoAddOnsDAO.actualizaAddOn(addOn);
			}
		}
	}
	
	public boolean seRepitePais(String pais){
		boolean ret = false;
		List<String> paises = null;
		
		try {
			paises = catalogoAddOnsDAO.obtenerPaisesAddOns();
			
			for(String sig : paises){
				if(pais.equals(sig)){
					ret = true;
				}
			}
		}catch(Exception ex) {
			logger.error("Error : [{}]", ex);
			ret = true;
		}
		
		return ret;
	}
	
	public void eliminaprecioAddOn(Integer idAddOn, String preferido, Integer idRelacion) {
		catalogoAddOnsDAO.eliminaPrecioAddon(idAddOn);
		if(preferido.equals("SI")) {
			catalogoAddOnsDAO.actualizaPreferidoAddOnPorBorrado(idRelacion);
		}
	}
	
}
