package com.mx.dla.dda.admin.catalogos.transacciones.bos;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.ReporteAddonDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.daos.TransaccionesDAO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.CategoriasDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ConfiguracionesDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.EstudiosTransDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ExcepcionesTransDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ReporteGeneralDTO;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.reporte.pago.dtos.ReporteAddOnRowDTO;
import com.mx.dla.global.bos.BaseBO;

@Service
public class TransaccionesBO extends BaseBO {

	@Autowired
	TransaccionesDAO transacciones;
	
	@Autowired
	private ExcelMapperContext excelMapperContext;
	
	@Autowired
	protected ExcelMapperTransform excelMapperTransform;

	public List<ExcepcionesTransDTO> getExcepciones() {
		return transacciones.getExcepciones();
	}

	public List<CategoriasDTO> getCategorias() {
		return transacciones.getCategorias();
	}

	public List<EstudiosTransDTO> getEstudiosTrans() {
		return transacciones.getEstudiosTrans();
	}

	public void agregarExcepcion(ExcepcionesTransDTO excepcion) {
		transacciones.agregarExcepcion(excepcion);
	}

	public void agregarCategoria(CategoriasDTO categoria) {
		transacciones.agregarCategoria(categoria);
	}

	public void agregarEstudioTrans(EstudiosTransDTO estudio) {
		transacciones.agregarEstudioTrans(estudio);
	}

	public void eliminarEstudio(EstudiosTransDTO estudio) {
		transacciones.eliminarEstudio(estudio);
		
	}

	public void eliminarCategoria(CategoriasDTO categoria) {
		transacciones.eliminarCategoria(categoria);
		
	}

	public void eliminarExcepcion(ExcepcionesTransDTO excepcion) {
		transacciones.eliminarExcepcion(excepcion);		
	}

	public CategoriasDTO getCategoriaById(String idCategoria) {
		return transacciones.getCategoriaById(idCategoria);
	}

	public void updateCategoria(CategoriasDTO categoria) {
		transacciones.updateCategoria(categoria);
	}

	public EstudiosTransDTO getEstudioTransById(String idEstudio) {
		return transacciones.getEstudioTransById(idEstudio);
	}

	public void updateEstudioTrans(EstudiosTransDTO estudio) {
		transacciones.eliminarEstudioByName(estudio);
		transacciones.agregarEstudioTrans(estudio);
	}

	public ExcepcionesTransDTO getExcepcionesById(String idExcepcion) {
		return transacciones.getExcepcionesById(idExcepcion);
	}

	public void updateExcepcion(ExcepcionesTransDTO excepcion) {
		transacciones.updateExcepcion(excepcion);
	}
	
	public List<ReporteGeneralDTO> reporteGeneral(String anio, String mes, String estudio) {
		return transacciones.reporteGeneral(anio, mes, estudio);		
	}
	
	public InputStream obtenerReporteEnExcel(String anio, String mes, String estudio) {

		byte[] info = null;
		InputStream reporteGeneral = null;
		List<ReporteGeneralDTO> reporte = null;
		
		try {
			
			logger.debug("antes de reporte");
			reporte = transacciones.reporteGeneral(anio, mes, estudio);
			logger.debug("Regresando reporte");
		}catch(Exception ex){
			logger.error("[{}]", ex);
			logger.debug("No regresa reporte ");
		}
		
		ExcelMapper mapper = excelMapperContext.getExcelMapper("reporteTransaccionesGeneral");
		
		try{

			info = excelMapperTransform.transformObjectToExcel(reporte, mapper, ReporteGeneralDTO.class);
			reporteGeneral = new ByteArrayInputStream(info);
		}catch(Exception e){
			logger.error("Error : " + e);
		}
		return reporteGeneral;
	}

	public ExcepcionesTransDTO validaExcepcionExistente(ExcepcionesTransDTO excepcion) {
		
		return transacciones.validaExcepcionExistente(excepcion);
		
	}
	
	public ConfiguracionesDTO validaMescerrado(ExcepcionesTransDTO excepcion) {
		return transacciones.validaMesCerrado(excepcion);
	}

	public void cerrarRporte(String fecha) {
		transacciones.cerrarReporte(fecha,"FECHA_CIERRE_TRANS");
	}

	public void reabrirReporte(String mes, String anio) {
		transacciones.reabrirReporte(mes, anio);
	}

}
