package com.mx.dla.dda.catalogos.bos;

import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.admin.catalogos.estudios.daos.CatalogoEstudiosDAO;
import com.mx.dla.dda.admin.catalogos.estudios.dtos.CatalogoContratoDTO;
import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.catalogos.dtos.CategoriaDTO;
import com.mx.dla.dda.catalogos.dtos.EmpresaVentaDTO;
import com.mx.dla.dda.catalogos.dtos.EstatusDTO;
import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.catalogos.dtos.FormatoDTO;
import com.mx.dla.dda.catalogos.dtos.MedioEntregaDTO;
import com.mx.dla.dda.catalogos.dtos.PaisVentaDTO;
import com.mx.dla.dda.catalogos.dtos.RegionVentaDTO;
import com.mx.dla.dda.catalogos.dtos.ReleaseDTO;
import com.mx.dla.dda.catalogos.dtos.ServicioDTO;
import com.mx.dla.dda.catalogos.dtos.TerritorioDTO;
import com.mx.dla.dda.contrato.fees.dtos.TiempoVidaDTO;
import com.mx.dla.dda.contrato.fees.dtos.TipoSuscriptorDTO;

@Component
public class CatalogosBO {

	@Autowired
	private CatalogosDAO catalogosDAO;
	
	@Autowired
	private CatalogoEstudiosDAO contratosDAO;

	public List<EstudioDTO> obtenListaEstudios() {
		return catalogosDAO.obtenerEstudios();
	}

	public List<CategoriaDTO> obtenListaCategorias() {
		return catalogosDAO.obtenerCategorias();
	}

	public List<ServicioDTO> obtenListaServicios() {
		return catalogosDAO.obtenerServicios();
	}

	public List<TerritorioDTO> obtenListaTerritorios() {
		return catalogosDAO.obtenerTerritorios();
	}

	public List<MedioEntregaDTO> obtenListaMediosEntrega() {
		return catalogosDAO.obtenerMediosEntrega();
	}

	public List<EstatusDTO> obtenerEstatus() {
		return catalogosDAO.obtenerEstatus();
	}

	public List<FormatoDTO> getFormatos() {
		return catalogosDAO.getFormatos();
	}

	public List<ReleaseDTO> getReleases() {
		return catalogosDAO.getReleases();
	}

	public List<PaisVentaDTO> getPaises() {
		return catalogosDAO.getPaises();
	}

	public int obtenSqIdContrato(String tipoOperacion, int idContrato) {
		if (tipoOperacion.equals("Alta")) {
			idContrato = catalogosDAO.obtenerSqIdContrato();
		}
		return idContrato;
	}

	public List<EmpresaVentaDTO> getEmpresasVenta() {

		List<EmpresaVentaDTO> empresas = new ArrayList<EmpresaVentaDTO>();
		empresas = catalogosDAO.getEmpresasVenta();
		return empresas;
	}

	public PaisVentaDTO getPaisXId(Long idPais) {
		return catalogosDAO.getPaisXId(idPais);
	}

	public RegionVentaDTO getRegionXId(@Param("id") Long id) {
		return catalogosDAO.getRegionXId(id);
	}

	public List<RegionVentaDTO> getRegiones() {
		return catalogosDAO.getRegiones();
	}

	public List<TipoSuscriptorDTO> obtenerTipoSuscriptor() {
		return catalogosDAO.obtenerTipoSuscriptor();
	}

	public List<TiempoVidaDTO> obtenerTiempoVida() {
		return catalogosDAO.obtenerTiempoVida();
	}

	public List<CatalogoDTO> obtenCatalogoEmpresas(List<Long> idEmpresas, List<Long> idPaises, List<String> descEmpresas, List<Long> staEmpresas) {
		return catalogosDAO.obtenCatalogoEmpresas(idEmpresas, idPaises, descEmpresas, staEmpresas);
	}

	public List<CatalogoDTO> obtenCatalogoAreas(List<Long> idAreas, List<String> descAreas, List<Long> indAutorizaContratoAreas, List<Long> ordenAreas) {
		return catalogosDAO.obtenCatalogoAreas(idAreas, descAreas, indAutorizaContratoAreas, ordenAreas);
	}

	public List<CatalogoDTO> obtenCatalogoPerfiles(List<Long> idPerfiles, List<String> descPerfiles, List<Long> staPerfiles) {
		return catalogosDAO.obtenCatalogoPerfiles(idPerfiles, descPerfiles, staPerfiles);
	}

	public List<CatalogoDTO> obtenCatalogoEstudios(List<Long> idEstudios, List<Long> idSapEstudios, List<String> descEstudios, List<String> monedaEstudios, List<String> codigoPaisEstudios,
	        List<String> nombrePaisEstudios, List<String> sociedadEstudios, List<String> siglaDdaEstudios, List<Long> ordenEstudios, List<Long> idGroupEstudios) {
		return catalogosDAO.obtenCatalogoEstudios(idEstudios, idSapEstudios, descEstudios, monedaEstudios, codigoPaisEstudios, nombrePaisEstudios, sociedadEstudios, siglaDdaEstudios, ordenEstudios,
		        idGroupEstudios);
	}
	
	public List<CatalogoDTO> obtenCatalogoPeliculasSeries(long idEstudio) {
		return catalogosDAO.buscarCatalogoTitulosCPV(idEstudio);
	}
	public List<CatalogoDTO> obtenCatalogoTemporadas(long idEstudio, String nombreUnico) {
		return catalogosDAO.buscarCatalogoTemporadas(idEstudio,nombreUnico);
	}
	
	/** RFD **/
	public List<CatalogoDTO> obtenContratos(long idEstudio) {
		return catalogosDAO.buscarContratosPorEstudio(idEstudio);
	}
	public List<CatalogoDTO> obtenCatalogoPeliculasSeriesDC(long contrato) {
		return catalogosDAO.buscarCatalogoTitulosDC(contrato);
	}
	public List<CatalogoDTO> obtenCatalogoTemporadasDC(long idEstudio, Long nombreUnico) {
		return catalogosDAO.buscarCatalogoTemporadasDC(idEstudio,nombreUnico);
	}
	/** RFD **/
	
	public List<CatalogoContratoDTO> getContratosByEstudio(Long idEstudio) {
		return contratosDAO.contratosByEstudio(idEstudio);
	}
	
}
