package com.mx.dla.dda.contrato.amortizacion.bos;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.contrato.amortizacion.daos.AmortizacionDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.bos.TituloGridBO;
import com.mx.dla.dda.contrato.titulo.daos.ListaDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDmDAO;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.ws.amortizacioncontrato.ContratoTituloDTO;
import com.mx.dla.dda.contrato.ws.amortizacioncontrato.ParamCalcAmortCntDTO;
import com.mx.dla.dda.contrato.ws.amortizacioncontrato.ResponseCalcAmortCntDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;


@Service
public class AmortizacionBO extends BaseBO{
	
	@Autowired
	private AmortizacionDAO amortizacionDAO;
	
	@Autowired
	private TituloGridBO tituloGridBO;
	
	@Autowired
	protected ListaDAO listaDAO;
	
	@Autowired
	private TituloDmDAO tituloDmDAO;
	
	@Autowired
	public DLARestClientFactory dlaRestClientFactory;
	
	public Lista buscarListaActual(ContratoDTO c)
	{
		return listaDAO.buscarListaActual(c.getIdContrato(), Lista.REAL);
	}
	
	public List<Titulo> busqueda(ContratoDTO c, Lista lista, Titulo t)throws TituloException
	{
		Integer oc = amortizacionDAO.getContratoProceso(c.getIdContrato());
		logger.debug("Recarga amortizacion {}",oc);
		if(oc != null && oc != 0)
		{
			this.calculaAmortizacionTodosLosTitulos(c.getIdContrato(),lista.getIdLista()  , false , new ArrayList<Long>(), Lista.REAL);
			amortizacionDAO.updateContratoProceso(c.getIdContrato(), 0);
		}
		
		return tituloGridBO.busqueda(t, true, Lista.REAL);
	}
	
	public List<Titulo> busquedaDetalle( Titulo t)throws TituloException
	{
		return tituloGridBO.busquedaDetalle(t, true, Lista.REAL);
	}
	
	public void calculaAmortizacionTodosLosTitulos(Long idContrato ,Long idLista , boolean parcial , List<Long> idTitulos, String prefix) {
		try
		{
			Long totalT = tituloDmDAO.cuentaTitulosPorListaYDescTitulo(idLista, null, prefix);
			logger.debug("Total Titulos [{}]",totalT);
			if(totalT != 0){
				ParamCalcAmortCntDTO req = new ParamCalcAmortCntDTO();
				req.setIdContrato(idContrato.toString());
				//req.setModulo("AMORTIZACION");
				
				/*
				if(idTitulos!= null)
				{
					@SuppressWarnings("unchecked")
				List<ContratoTituloDTO> toSend = (List<ContratoTituloDTO>) CollectionUtils.collect(idTitulos, new Transformer() {
						
						@Override
						public Object transform(Object arg0) {
							ContratoTituloDTO r = new ContratoTituloDTO();
							Long t = (Long) arg0;
							r.setID_TITULO_CNT(t.toString());
							return r;
						}
					});
					req.setLobTitulos(toSend);
				}*/
				
				
				logger.debug("Request Calculo de amortizacion [{}]",req);
				DLARestClient cleinteGeneraAmortizacion = dlaRestClientFactory.getClient(DLARestServices.GENERA_AMORTIZACION2);
				ResponseCalcAmortCntDTO resp = cleinteGeneraAmortizacion.get(req, ResponseCalcAmortCntDTO.class);
			    logger.debug("Response Calculo de amortizacion [{}]",resp);
			}
		}catch(Exception e)
		{
			logger.error("Error ",e);
		}
	}

}
