package com.mx.dla.dda.contrato.common.bos;

import java.io.File;
import java.io.IOException;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.contrato.common.daos.DocumentoDAO;
import com.mx.dla.dda.contrato.common.dtos.DocumentoDTO;
import com.mx.dla.global.bos.BaseBO;

@Service
public class DocumentoBO extends BaseBO{
	
	@Autowired
	private DocumentoDAO documentoDAO;
	
	@Value("${uri.file.store}")
	private String uri;

	public DocumentoDTO insertarDocumento(File file, String name, String expediente,Long idContrato) throws IOException {
		DocumentoDTO doc = new DocumentoDTO();
		
		doc.setExpediente(expediente);
		doc.setIdContrato(idContrato);
		doc.setNombre(name);
		doc.setRutaServidor(uri);
		logger.debug("URI file system {}",uri);
		logger.debug("Doc  to insert {}",doc);
		documentoDAO.insertarDocumento(doc);
		
		File destFile = new File(uri+doc.getIdContratoDocto());
		
		FileUtils.copyFile(file, destFile);
		logger.debug("file save correctly {}",name);
		return doc;
	}

	public DocumentoDTO remplazarDocumento(File file, String name, String expediente,Long idContrato, Long idDoc) throws IOException {
		
		logger.debug("Remplzar {}", idDoc);
		DocumentoDTO doc = new DocumentoDTO();
		
		doc.setExpediente(expediente);
		doc.setIdContrato(idContrato);
		doc.setNombre(name);
		doc.setRutaServidor(uri);
		doc.setIdContratoDocto(idDoc);
		logger.debug("URI file system {}",uri);
		logger.debug("Doc  to insert {}",doc);
		documentoDAO.updateDocumento(doc);
		
		File destFile = new File(uri+doc.getIdContratoDocto());
		
		FileUtils.copyFile(file, destFile);
		logger.debug("file save correctly {}",name);
		return doc;		
	}

	public void borrarDocumento( Long idContratoDocto) {
		documentoDAO.borrarDocumento(idContratoDocto);
	}

	public DocumentoDTO buscarDocumento( Long idContratoDocto) {
		return documentoDAO.buscarDocumento(idContratoDocto);
	}

	public List<DocumentoDTO> buscarDocumentos( Long idContrato) {
		return documentoDAO.buscarDocumentos(idContrato);
	}
	
	public DocumentoDTO obtenerUltimoDocumento(Long idContrato) {
		
		DocumentoDTO documento = null;
		
		try {
			documento = documentoDAO.obtenerUltimoDocumento(idContrato);
		}catch(Exception ex){
			logger.error("Error : [{}]", ex);
		}
		
		return documento;
	}
	
	
}
