package com.mx.dla.dda.contrato.facturas.bos;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.contrato.facturas.daos.FacturasDAO;
import com.mx.dla.dda.contrato.facturas.dtos.FacturaDbDTO;
import com.mx.dla.dda.contrato.facturas.dtos.FacturaViewDTO;
import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.global.bos.BaseBO;

@Service
public class FacturasBO extends BaseBO {

	@Autowired
	private FacturasDAO	 facturasDAO;

	@Autowired
	private GeneralesDAO generalesDAO;

	public List<FacturaViewDTO> buscarFacturas(Long idContrato) {
		List<FacturaDbDTO> source = new ArrayList<FacturaDbDTO>();

		ContratoDTO contrato = generalesDAO.obtenerContrato(idContrato);

		source = facturasDAO.buscarFacturas(contrato.getIdContratoOriginal());

		return transformBdToViewFactura(source);
	}

	/*	public Double buscarCostoTotal(Long idContrato) {
			return facturasDAO.buscarCostoTotalMateriales(idContrato);
		}*/

	public List<FacturaViewDTO> transformBdToViewFactura(List<FacturaDbDTO> source) {
		List<FacturaViewDTO> target = new ArrayList<FacturaViewDTO>();
		try {
			for (FacturaDbDTO itemSource : source) {
				FacturaViewDTO itemTarget = new FacturaViewDTO();
				BeanUtils.copyProperties(itemTarget, itemSource);
				target.add(itemTarget);
			}
		}
		catch (IllegalAccessException | InvocationTargetException e) {
			logger.debug("Error en transform de factura: {}", e);
		}

		return target;
	}
}
