package com.mx.dla.dda.contrato.fees.bos;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.constants.ExcelMapperDataType;
import com.mx.dla.dda.excelMapper.dtos.ExcelEntityResult;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.dtos.ExcelRule;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.global.bos.BaseBO;
import com.mx.dla.global.dtos.FilaExcelDTO;

@Service
public class FeesArchivoBO extends BaseBO{
	
	@Autowired 
	private ExcelMapperTransform excelMapperTransform;

	@Value("${uri.file.carga.fees}")
	protected String uriCarga;
	
	public byte[] leerTemplateFees() throws IOException{
		String nombreArchivo = "templateFees/dda_plantillaFeesFlat.xlsx";
		byte[] str = getFile(nombreArchivo);
		return str;
	}	
	
	private byte[] getFile(String fileName) throws IOException{				  		
		  ClassLoader classLoader = getClass().getClassLoader();		  		  
		  InputStream stream = classLoader.getResourceAsStream(fileName);		  
		  byte[] byteArr = IOUtils.toByteArray(stream);
		  return byteArr;			  
	}
	
	public InputStream getResource(String filePath) throws NoSuchFileException
    {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(filePath);
        if(inputStream == null)
        {
        	logger.error("No existe archivo");
            throw new NoSuchFileException("Resource file not found. Note that the current directory is the source folder!");            
        }
        return inputStream;
    }

	public List<FilaExcelDTO> obtenerDatosExcel(String nombreArchivo) throws ExcelMapperException{
		   List<FilaExcelDTO> filas = new ArrayList<FilaExcelDTO>();

		   ExcelMapper mapper = new ExcelMapper();
		   mapper.setClassName("com.mx.dla.global.dtos.FilaExcelDTO");
		   mapper.setFirstRow(1);
			
		   List<ExcelRule> rules = new ArrayList<ExcelRule>();
		   ExcelRule er = new ExcelRule();
		   
		   er.setType(ExcelMapperDataType.string);			
		   er.setAttribute("fila");
		   rules.add(er);
		   
		   mapper.setRules(rules);			
						
		   ExcelEntityResult<Object> res = excelMapperTransform.readExcelToObject(nombreArchivo, mapper);
			
		   for(int i=0; i<res.getResult().size(); i++)
		   {
			  FilaExcelDTO fila = (FilaExcelDTO)res.getResult().get(i);
			  filas.add(fila);
		   }
		   
		   return filas;
	}
	
	public List<FilaExcelDTO> obtenerDatosExcel(File fileUpload, String fileName, String expediente, Long idContrato ) throws IOException, ExcelMapperException{		
		String nombreArchivo = uriCarga + idContrato + expediente + fileName;
		byte [] f = FileUtils.readFileToByteArray(fileUpload);
		File d    = new File(nombreArchivo);
		
		d.setExecutable(true, false);
		d.setReadable(true, false);
		d.setWritable(true, false);
		
		logger.debug("Absolute path [{}]  -  [{}]",d.getCanonicalPath() , d.getPath());
		FileUtils.writeByteArrayToFile(d, f);		
		
		List<FilaExcelDTO> datos = this.obtenerDatosExcel(nombreArchivo);
		return datos;	
	}

}