package com.mx.dla.dda.contrato.transaccion.terminos.bos;

import java.io.IOException;
import java.util.List;

import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.ExcepcionesSeccionDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.FsCategoriaMGDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.LibreriaDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.MinimoGarantizadoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.PrecioRentaDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.RevenueBoxGloDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.SeccionesTerminos;
import com.mx.dla.global.bos.BaseBO;

@Service
public class TerminosLibreria extends BaseBO{

	@Autowired
	private TerminosMinimos minimos;
		
	@Autowired
	@Qualifier("precioLibreria")
	private TerminosPrecio precio;
	
	@Autowired
	private TerminosRevenue revenue;
	
	@Autowired
	private TerminosExcepciones excepciones;

			
	public LibreriaDTO obtenerLibreria(Long idContrato)throws TransaccionException{
		LibreriaDTO revenueDTO = new LibreriaDTO();
		
		try
		{

						
			MinimoGarantizadoDTO minimo   = minimos.obtenerMinimos(idContrato, SeccionesTerminos.RentaLibreria.getDesc());						

			PrecioRentaDTO price        = precio.obtenerDatosPreciosLibreria(idContrato, SeccionesTerminos.RentaLibreria.getDesc());

			ExcepcionesSeccionDTO excepcionesDTO = excepciones.obtenerExcepciones(idContrato, SeccionesTerminos.RentaPremium.getDesc());
			
			RevenueBoxGloDTO revenueDatos = revenue.obtenerRevenueLibreria(idContrato, SeccionesTerminos.RentaLibreria.getDesc());
			
			revenueDTO.setMinimos(minimo);			
			revenueDTO.setPrecio(price);
			revenueDTO.setExcepciones(excepcionesDTO); 
			revenueDTO.setRevenue(revenueDatos);					
						
		}catch(Exception e){
			new TransaccionException("Error al obtener terminos premium.", e);
		}								
		return revenueDTO;		
	}
	
	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public void guardarLibreria(LibreriaDTO p, Long idContrato) throws JsonParseException, JsonMappingException, IOException, TransaccionException{
		
		try
		{
			logger.debug(p.toString());						
			
            revenue.eliminarMinimosCategoriasBoxOffice(idContrato, SeccionesTerminos.RentaLibreria.getDesc());
			revenue.elimnarRevenueGlobal(idContrato, SeccionesTerminos.RentaLibreria.getDesc());
            precio.eliminarPaisesImpuestoEstatus(idContrato, SeccionesTerminos.RentaLibreria.getDesc());
            precio.eliminarPreciosLibreria(idContrato);
			excepciones.eliminarExcepcion(idContrato, SeccionesTerminos.RentaLibreria.getDesc());

			minimos.guardarMinimos(p.getMinimos().getMinimosCateg(), p.getMinimos().getMinimosAnio(), p.getMinimos().getAnios(), p.getMinimos().getTipoMin(), SeccionesTerminos.RentaLibreria.getDesc(), idContrato);								
			
			precio.actualizarPrecioAplica(idContrato, SeccionesTerminos.RentaLibreria.getDesc(), p.getPrecio().getAplica());
			precio.actualizarPagoPpe(idContrato, SeccionesTerminos.RentaLibreria.getDesc(), p.getPrecio().getPagoPPE());
			
			if(p.getPrecio().getAplica().intValue() == 1)
			  precio.guardarDatosPreciosLibreria(p.getPrecio(), idContrato, SeccionesTerminos.RentaLibreria.getDesc());

			revenue.guardarRevenueLibreria(idContrato, SeccionesTerminos.RentaLibreria.getDesc(), p.getRevenue());
			excepciones.guardarExcepciones(idContrato, SeccionesTerminos.RentaLibreria.getDesc(), p.getExcepciones());

		
		}
		catch(Exception e){
			new TransaccionException("Error al obtener terminos premium.", e);
		}		
	}
	
}
