package com.mx.dla.dda.ncredito.general.bos;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;





import com.mx.dla.dda.ncredito.general.dtos.ContratoNotaCreditoDetalleDTO;
import com.mx.dla.dda.ncredito.general.dtos.ContratoNotaCreditoGeneralDTO;
import com.mx.dla.dda.ncredito.ws.dtos.DTNotaCredito;
import com.mx.dla.dda.ncredito.ws.dtos.DTNotaCredito.Registro;
import com.mx.dla.dda.ncredito.ws.dtos.DTNotaCredito.Registro.Item;
import com.mx.dla.global.bos.BaseBO;

@Component
public class NCreditoConvertidordDto2Rest extends BaseBO {

	@Value("${factura.header.sociedad}")
	protected String sociedad;

	@Value("${factura.header.indicador}")
	protected String indicador;

	@Value("${notaCredito.header.tipoDocumento}")
	protected String tipoDocumento;

	@Value("${factura.header.moneda}")
	protected String moneda;

	@Value("${factura.detalle.impuesto}")
	protected String impuesto;

	@Value("${factura.detalle.cantidad}")
	protected String cantidad;

	@Value("${envMov.indEntregaFinal}")
	protected String indEntregaFinal;

	@Value("${envMov.indFacturaFinal}")
	protected String indFacturaFinal;

	@Value("${envMov.noItem}")
	protected String noItem;

	@Value("${notaCredito.detalle.isoMedida}")
	protected String isoMedida;

	public DTNotaCredito generaFacturaWS(ContratoNotaCreditoGeneralDTO facturaDTO/*, String estudio, String monedaEstudio, String codigoSap*/) {
		DTNotaCredito message = new DTNotaCredito();
		Registro factura = generaRegistro(facturaDTO/*, estudio, monedaEstudio*/);
		Double totalMonto = 0.0;
		List<Item> items = generaItems(facturaDTO.getContratos());
		for(Item item : items){
			totalMonto = totalMonto + new Double(item.getImporte());
		}
		

		factura.setMonto(totalMonto.toString());
		factura.setItem(items);
		message.setRegistro(factura);
		print(factura);
		return message;

	}

	public Registro generaRegistro(ContratoNotaCreditoGeneralDTO facturaDTO/*, String estudio, String monedaEstudio*/) {
		SimpleDateFormat ft = new SimpleDateFormat("dd.MM.yyyy");
		Registro factura = new Registro();

		factura.setSociedad(sociedad);
		factura.setIndFactura("");
		factura.setTipoDoc(tipoDocumento);
		factura.setMoneda(moneda);
		factura.setTexto(facturaDTO.getComentario());
		factura.setMonto(facturaDTO.getMonto());
		factura.setReferencia(facturaDTO.getNumeroFactura());
		factura.setFechaNotaCred(ft.format(facturaDTO.getFechaFactura()));
		factura.setFechaContab(ft.format(new Date()));
		

		return factura;
	}

	public List<Item> generaItems(List<ContratoNotaCreditoDetalleDTO> facturaDetalles) {
		List<Item> pocisiones = new ArrayList<Item>();
		Integer posicionNum = 10;

		for (ContratoNotaCreditoDetalleDTO item : facturaDetalles) {
			String posicionStr = "000" + posicionNum;
			Item posicion = new Item();
			posicion.setCantidad(cantidad);
			posicion.setImporte(item.getMonto());
						
			posicion.setIndImpuesto(item.getClaveIva()); // Iva por contrato
			posicion.setPedido(item.getIdSap()); // idSap por contrato
			posicion.setPosicionDoc(posicionStr);
			posicion.setPosicionPO(noItem);
			posicion.setUnidMedISO(isoMedida);

			pocisiones.add(posicion);
			posicionNum = posicionNum + 10;
		}
		return pocisiones;
	}

	public void print(Registro registro) {
		logger.info("getSociedad: " + registro.getSociedad());
		logger.info("getFechaContab: " + registro.getFechaContab());
		logger.info("getFechaNotaCred: " + registro.getFechaNotaCred());
		logger.info("getIndFactura: " + registro.getIndFactura());
		logger.info("getMoneda: " + registro.getMoneda());
		logger.info("getMonto: " + registro.getMonto());
		logger.info("getReferencia: " + registro.getReferencia());
		logger.info("getTexto: " + registro.getTexto());
		logger.info("getTipoDoc: " + registro.getTipoDoc());
		logger.info("getItem: " + registro.getItem());
		logger.info("**Posiciones**");
		if (registro.getItem() != null)
			for (Item posicion : registro.getItem()) {

				logger.info("getCantidad: " + posicion.getCantidad());
				logger.info("getImporte: " + posicion.getImporte());
				logger.info("getIndImpuesto: " + posicion.getIndImpuesto());
				logger.info("getPedido: " + posicion.getPedido());
				logger.info("getPosicionPO: " + posicion.getPosicionPO());
				logger.info("getPosicionDoc: " + posicion.getPosicionDoc());

				logger.info("getUnidMedISO: " + posicion.getUnidMedISO());

			}
	}

}