package com.mx.dla.dda.reportes.ExcelGeneratorProcess.bos;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.general.utilerias.ListaUtilerias;
import com.mx.dla.dda.general.utilerias.ProcesosUtilerias;
import com.mx.dla.dda.general.utilerias.ShellResponseDTO;
import com.mx.dla.global.bos.BaseBO;
import com.mx.dla.global.bos.CustomResourceLoader;

@Service
public class ExcelGeneratorProcessBO extends BaseBO {

	@Autowired
	private CustomResourceLoader customResourceLoader;

	@Value("${excel.shellPath}")
	private String				 rutaShell;

	@Value("${excel.process.path}")
	private String				 rutaSoftware;

	@Value("${excel.process.source.path}")
	private String				 rutaFuentes;

	@Value("${excel.process.target.path}")
	private String				 rutaResultado;

	@Value("${excel.shellName}")
	private String				 archivoShell;

	@Value("${excel.process.source.style}")
	private String				 archivoEstilos;

	// @Value("${excel.process.source.data}") private String archivoFuente;
	// @Value("${excel.process.targetName}") private String archivoResultado;

	@Value("${excel.process.tipo}")
	private String				 tipo;

	@Value("${excel.process.bloqueo}")
	private String				 bloqueo;

	@Value("${excel.process.password}")
	private String				 password;

	public InputStream generaExcelProceso(String xmlTablaNombre, String xlsArchivoNombre) throws IOException {

		logger.info("{} {}", rutaShell, rutaSoftware);
		logger.info("{} {}", rutaFuentes, rutaResultado);
		logger.info("{} {}", archivoShell, tipo);
		logger.info("{} {}", bloqueo, password);

		ShellResponseDTO response = ProcesosUtilerias
		        .ejecutaShell(new String[] { rutaShell + "/" + archivoShell, rutaSoftware, rutaFuentes, rutaResultado, xmlTablaNombre, archivoEstilos, xlsArchivoNombre, tipo, bloqueo, password });

		for (String item : ListaUtilerias.safeList(response.getOutputData()))
			logger.info("{}", item);

		for (String item : ListaUtilerias.safeList(response.getErrorData()))
			logger.info("{}", item);

		String absoluteFileName = rutaResultado + "/" + xlsArchivoNombre;

		return new ByteArrayInputStream(FileUtils.readFileToByteArray(FileUtils.getFile(absoluteFileName)));
	}

	public String guardaFuenteProceso(byte[] stream, String fileName) throws IOException {

		String absoluteFileName = rutaFuentes + "/" + fileName;

		logger.info("{}", absoluteFileName);

		File d = new File(absoluteFileName);
		d.setExecutable(true, false);
		d.setReadable(true, false);
		d.setWritable(true, false);

		FileUtils.writeByteArrayToFile(d, stream);

		return new String();
	}

	public String generaFuenteProceso(List<HashMap<String, String>> data, String nombreArchivo) throws IOException, InvalidFormatException {
		// PRoceso de generacion con datos
		byte[] tempoFile = customResourceLoader.getFile2ByteArray("classpath:tempoFiles/plantilla.xml");

		guardaFuenteProceso(tempoFile, nombreArchivo);

		return new String();
	}

}