var idEstudio;

$(document).ready(
	function() {
		inicial();
	}
);

function inicial(){
	limpiarTabla();
	realizaConsulta();
	inicializarBotones();
	$("table thead tr").addClass("encabezado");
}

function limpiarTabla(){	
	$('#divTablaIn').remove();
	var div = '<div id="divTablaIn"></div>';
	$('#divTablaExt').append(div);
	var tabla = $("<table class='table table-striped'/>").attr('id',"cataEstudio");       
	$("#divTablaIn").append(tabla);	
}

function realizaConsulta(){				
	// Obtener numero de menu
	var menu        = $("#pmn").val();
	var menuRegreso = $("#pmnReturn").val();
	var namespace = "/catalogos/estudios/";
    var rowId=null;
    var oTable=null;
     oTable=$('#cataEstudio').dataTable({		    
	   "bAutoWidth": false,
		"oLanguage":{	"sProcessing":     "Procesando...",
						"sLengthMenu":     "Mostrar _MENU_ registros",
						"sZeroRecords":    "Sin eventos encontrados",
						"sEmptyTable":     "Sin eventos encontrados",
						"sInfo":           "Mostrando  _START_ al _END_ de  _TOTAL_ ",
						"sInfoEmpty":      "0 registros",
						"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
						"sSearch":         "Buscar:",
						"sInfoThousands":  ",",
						"sLoadingRecords": "Cargando...",
						"oPaginate": {
							"sFirst":    "Primero",
				        	"sLast":     "&Uacute;ltimo",
				        	"sNext":     "Siguiente",
				        	"sPrevious": "Anterior"
				    	}
				},
		"iDisplayLength": 10,
		"bInfo"     : false,
		"bFilter"   : true,
		"bSort"     : false,
		"bPaginate" :true,
		"sPaginationType" : "full_numbers",
		"aaSorting": [],
		"sAjaxSource": "listadoEstudios",
		"sAjaxDataProp":"", 
	    "aoColumns": [
	                  	{"sTitle":"C&oacute;digo SAP"       ,"mDataProp":"idSap"              ,"bSearchable": true, sWidth : "400px"},
						{"sTitle":"Nombre"      ,"mDataProp":"descripcionEstudio" ,"bSearchable": true, sWidth : "500px"},
						{"sTitle":"Siglas"      ,"mDataProp":"siglaDda"           ,"bSearchable": true, sWidth : "400px"},
						{"sTitle":"Grupo"      ,"mDataProp":"descripcionGrupo" ,"bSearchable": true, sWidth : "500px"},
						{"sTitle":"Moneda"      ,"mDataProp":"moneda"             ,"bSearchable": true, sWidth : "400px"},
	          			{"sTitle":"C\u00F3digo Pa\u00EDs" ,"mDataProp":"codigoPais"         ,"bSearchable": true, sWidth : "400px"},
						{"sTitle":"Nombre Pa\u00EDs" ,"mDataProp":"nombrePais"         ,"bSearchable": true, sWidth : "400px"},
						{"sTitle":"Sociedad"    ,"mDataProp":"sociedad"           ,"bSearchable": true, sWidth : "400px"}
	          			],
	    		        'fnRowCallback': function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
	    		        
	    		        	var link = '<a onClick="guardaIdEstudio('+aData["idEstudio"]+')" data-toggle="modal" data-target="#modalAgregaActualiza"> ' + aData["descripcionEstudio"] +'</a>';
	    		        	
	    		        	$(nRow).attr("id",aData["idEstudio"]);		   		        	 	
	    		        	$('td:eq(0)', nRow).html(aData["idSap"]);
	    		        	$('td:eq(1)', nRow).html(link);
		          			$('td:eq(2)', nRow).html(aData["siglaDda"]);
	    		        	$('td:eq(3)', nRow).html(aData["descripcionGrupo"]);
		          			$('td:eq(4)', nRow).html(aData["moneda"]);
		          			$('td:eq(5)', nRow).html(aData["codigoPais"]);
		          			$('td:eq(6)', nRow).html(aData["nombrePais"]);
		          			$('td:eq(7)', nRow).html(aData["sociedad"]);
	   		       		}
		});
     
}

function validarAgregar(){
	
	$("#forma").validate(
		      {
		        rules: 
		        {
		        	nombreEstudio: 
		          {
		            required: true,
		            maxlength: 50,
		            regex:"^[a-zA-Z0-9 ]+$"
		          }
		        },
		        messages: 
		        {
		        	nombreEstudio: 
		          {
		            required: "Nombre del Estudio es obligatorio.",
		            maxlength: "Nombre no debe exceder 50 caracteres",
		            regex: "Nombre debe ser con caracteres alfanum\u00E9ricos"
		          }
		        }
	});
	
	$.validator.addMethod("regex",function(value,element,regexp){
	      var re= new RegExp(regexp);
	      return this.optional(element) || re.test(value);
	},"Only Characters from A-z");
}

function inicializarBotones(){
	$("#nuevo").click(function()  
	{		
		window.location.href = contextPath + "/catalogos/estudios/dirigirAgregarEstudio.action?pmn=42&pmnReturn=42";				
	});
}

function regreso(){	
	var menu = $("#pmn").val();
	if(menu == '' || menu == null || menu == undefined)
		menu = 42;
	window.location.href = contextPath + "/catalogos/estudios/index.action?pmn=" + menu;
}

function guardaIdEstudio(idEstud) {	
	idEstudio = idEstud;
	llamaObtenEstudio(idEstud);
}

function llamaObtenEstudio(idEstudio) {
	var jsonString = '{"idEstudio" : "'+ idEstudio +'"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/estudios/llamaObtenEstudio", stringJson, procesaRespuestaObtenEstudio);
}

function procesaRespuestaObtenEstudio(jsonData) {
	var est = jsonData.estudio;
	var grups = jsonData.grupos;
	var grup;
	//debugger
	$('#inpNombreEstudio').val(est.descripcionEstudio);
	$('#inpMoneda')       .val(est.moneda);
	$('#inpNombrePais')   .val(est.nombrePais);
	$('#inpCodigoPais')   .val(est.codigoPais);
	$('#inpSociedad')     .val(est.sociedad);
	$('#inpIdSap')        .val(est.idSap);
	$('#inpSiglaDDA')     .val(est.siglaDda);
	
	$('#inpNombreAddon').val(est.addOn);
	
	var cb = document.querySelector('#checkAddOn');
	est.esAddOn == "1" ? cb.checked=true : cb.checked=false;
	
	$('#campoGrupo').children().remove();
	
	var option;
	for(var i = 0; i < grups.length; i++){
		grup = grups[i];
					
		if(est.idGrupo == grup.idGrupo) {
			$('#campoGrupo').append('<option value="'+ grup.idGrupo +'" selected> '+ grup.descripcionGrupo +' </option>');
		}else {
			$('#campoGrupo').append('<option value="'+ grup.idGrupo +'"> '+ grup.descripcionGrupo +' </option>');
		}						
	}
	
	if(est.idSap == '' || est.idSap == null || est.idSap == undefined){
		$("#inpSiglaDDA").prop( "disabled", true );
		$("#campoGrupo") .prop( "disabled", true );
	}	
	else
	{
		$("#inpSiglaDDA").prop( "disabled", false);
		$("#campoGrupo") .prop( "disabled", false);
	}
	if(est.tieneContratos == true)
	{
		$("#inpSiglaDDA").prop( "disabled", true );		
	}
}

function llamaActualizaEstudio() {
	var esAddOnVal = 0;
	
	if(checkAddOn.checked){
		esAddOnVal = 1;
	}
	
	var sigla = $('#inpSiglaDDA').val();
	var jsonString = '{"idEstudio" : "'+ idEstudio + '", "sigla" : "' + sigla + '", "campoGrupo" : "' + $('#campoGrupo').val() + '", "esAddOn" : "' + esAddOnVal+ '", "nombreAddOn" : "' + $('#inpNombreAddon').val()  +'"}';	
	var patron = /^[A-z\d_]{2,3}$/;
	if(patron.test(sigla)) {
		var stringJson = JSON.parse(jsonString);
		callActionAjax( "/catalogos/estudios/llamaActualizaEstudio", stringJson, procesaRespuestaActualiza);
	}else {
		$('#modalAgregaActualiza').modal('hide');
		showError("La sigla debe ser alfanum\u00E9rica y su longitud de 2 o 3.");
	}

}

function procesaRespuestaActualiza(jsonData) {
	
	var seRepite = jsonData.seRepiteSigla;
	
	$('#modalAgregaActualiza').modal('hide');
	
	if(!seRepite) {
		showMessage("Actualizado con \u00E9xito");
	}else {
		showError("La sigla se repite en otro Estudio.");
	}
	
	inicial();	
}

function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	         showError("Problemas al enviar los datos.");
	     }
	 });	
}