function TituloGrid(gridId) {
	this.gridId = gridId;
	this.grid = null;
	var me = this;
	this.columnsFijas = [
		{ label: 'idTituloCnt', name: 'idTituloCnt', width: 250, hidden: true, frozen: true },
		{
			label: 'T&iacute;tulo', name: 'descTitulo', width: 200, sortable: false, frozen: true,
			formatter: function(cellvalue, options, rowObject) {
				var r = cellvalue;
				if (rowObject.agrupable == '1' && rowObject.nombreUnico != null) {
					r = "<a href='javascript:amController.cargaDetalle(\"" + rowObject.nombreUnico + "\")'>  <strong>   +" + cellvalue + "</strong>   </a> "
				}
				if (rowObject.agrupable == '0' && rowObject.nombreUnico != null) {
					r = "<a href='javascript:amController.reloadGrid()'>  <strong>-" + cellvalue + "</strong>   </a> "
				}
				return r;
			}
		},
		{ label: 'Categor&iacute;a Estudio', name: 'pagoCateg.desc', width: 130, mname: 'pagoCateg', sortable: false },
		{ label: 'Categor&iacute;a', name: 'categoriaTit.desc', width: 130, mname: 'categoriaTit', sortable: false },
		{ label: 'T', name: 'temporada', width: 30, sortable: false },
		{ label: 'Ep', name: 'episodio', width: 30, sortable: false },
		{
			label: 'Inicio', name: 'fechaInicio', width: 70, formatter: 'date', sortable: false,
			formatoptions: { newformat: 'm/d/Y' }
		},
		{
			label: 'Fin', name: 'fechaFin', width: 70, formatter: 'date', sortable: false,
			formatoptions: { newformat: 'm/d/Y' }
		},
		{ label: 'Costo', name: 'costo', width: 80, align: "right", formatter: 'currency', summaryType: 'sum', summaryRound: "2", summaryRoundType: "trunc", sortable: false },
		{ label: 'json', name: 'json', hidden: true, formatter: me.storeInfo },

		{ label: 'idLista', name: 'idLista', width: 250, hidden: true },
		{ label: 'agrupable', name: 'agrupable', width: 250, hidden: true },
		{ label: 'movieSerie', name: 'movieSerie', width: 200, hidden: true },
		{ label: 'bajaPerdida', name: 'bajaPerdida', width: 250, hidden: true },
		{ label: 'precioAnual', name: 'precioAnual', width: 250, hidden: true },
		{ label: 'Nombre General', name: 'nombreUnico', width: 200, hidden: true },
		{ label: 'pjeExclusivo', name: 'pjeExclusivo', width: 250, hidden: true },
		{ label: 'mesesExclusivo', name: 'mesesExclusivo', width: 200, hidden: true }
	];


	if ($("#tipoAmortizacion").val() == 'EXCLUSIVIDAD') {
		clm = { label: 'Exclusividad % - Meses', name: 'pjemesesExclusivo', width: 200 },
			this.columnsFijas.push(clm);
	}

	this.columns = this.columnsFijas.concat([]);
}

function validacionPresupuesto() {

	return $.ajax({
		url: contextPath + '/contrato/titulos/buscarPresupuestoTituloAsync.action',
		type: "post",
		success: function(ret) {
			var p = ret.presupuesto;
			var columns = [
				{ name: "amortizable" },
				{ name: "comprometido" },
				{ name: "disponible" },
				{ name: "contratoActual" },
				{ name: "amortizableEstudio" },
				{ name: "comprometidoEstudiod" },
				{ name: "disponibleEstudio" }
			];

			var formManager = new FormManager();
			formManager.llenarForma(p, "idFormPresupuesto", columns);

			if (p.errores != null) {
				if (p.errores.length != 0) { showError(p.errores); }
			}
			if (p.advertencias != null) {
				if (p.advertencias.length != 0) { showWarn(p.advertencias); }
			}
			if (p.mensajes != null) {
				if (p.mensajes.length != 0) { showMessage(p.mensajes); }
			}

		},
		error: function(jqXHR, textStatus, errorThrown) {
			showError("Ocurri\u00F3 un error");
		}
	});
}

function busquedaAmortizacion() {
	return $.ajax({
		url: contextPath + '/contrato/amortizacion/busquedaAmortizacionAction.action',
		type: "post",
		data: { "titulo.idLista": $("#idl").val() }
	});
}

TituloGrid.prototype.getColumns = function() {
	return this.columns;
};

TituloGrid.prototype.reload = function() {
	this.genericLoadData("getData");
};


TituloGrid.prototype.reloadDetails = function(nu) {
	this.genericLoadData("getDetails", nu);
};


TituloGrid.prototype.genericLoadData = function(loadData, nu) {
	var me = this;
	$("#dynTitulosGrid").html("<br><br><img src='" + contextPath + "/design/img/loading.gif' height='60' width='60'>");
	var items = me[loadData](nu);
}

TituloGrid.prototype.generateAmortizacionColumns = function() {
	var datosAmortizacion = new DatosAmortizacion("dAmortizacionGrid");
	var amortizaciones = datosAmortizacion.datos().amortizaciones;

	var amortColumns = [];
	for (var i = 0; i < amortizaciones.length; i++) {
		var column = {
			align: "right", width: 80, jsonmap: 'amortizacionesH.' + amortizaciones[i].value, sortable: false
			, formatter: function(cellvalue, options, rowObject) {
				if (typeof cellvalue == 'undefined' || cellvalue == null) {
					cellvalue = 0;
				}
				var r = $.fmatter.util.NumberFormat(cellvalue, $.jgrid.regional["es"].formatter.currency);
				if (rowObject.idTituloCnt == null && rowObject.nombreUnico == null) {
					r = "<a href=\"javascript:amController.openDialogAmortizacion('" + options.colModel.anio + "');\">" + r + "</a>";
				}
				return r;
			}
		};
		column["label"] = "Amort. " + amortizaciones[i].value;
		column["name"] = "amortizacionesH." + amortizaciones[i].value;
		column["anio"] = amortizaciones[i].value;
		amortColumns.push(column);
	}

	this.columns = this.columnsFijas.concat(amortColumns);
}

TituloGrid.prototype.itemsSelected = function() {
	var me = this;
	var ret = [];
	var rowId = $("#" + me.gridId).jqGrid('getGridParam', 'selarrrow');
	rowId.forEach(function(e, i) {
		var _t = jQuery("#" + me.gridId).getRowData(e);
		var _a = JSON.parse(_t.json);
		ret.push(_a);
	});
	return ret;

};

TituloGrid.prototype.renderCheckBox = function(cellvalue, options, rowObject) {
	var r = "<input type='checkbox' disabled='disabled'";
	if (cellvalue) { r += " checked='checked' "; }
	r += " />";
	return r;
};

TituloGrid.prototype.storeInfo = function(cellvalue, options, rowObject) {
	var r = JSON.stringify(rowObject);
	return r;
};

TituloGrid.prototype.validaPresupuesto = function() {
	var validacion = validacionPresupuesto();
};

TituloGrid.prototype.getData = function() {

	var tabla = this;
	var validacion = validacionPresupuesto();

	$.when(validacion).done(function(data) {
		busquedaAmortizacion().then(
			function(data) {
				tabla.generateAmortizacionColumns();
				items = data.titulos;
				tabla.init(items);
			},
			function(jqXHR, textStatus, errorThrown) {
				showError("Ocurri\u00F3 un error");
			}
		);
	});

};


TituloGrid.prototype.getDetails = function(nu) {
	var me = this;
	$.ajax({
		url: contextPath + '/contrato/amortizacion/busquedaDetalleAmortizacionAction.action',
		type: "post",
		data: {
			"titulo.idLista": $("#idl").val(),
			"titulo.nombreUnico": nu
		},
		success: function(ret) {
			var items = {};
			me.generateAmortizacionColumns();
			items = ret.titulos;
			me.init(items);
		}
	});
};

TituloGrid.prototype.init = function(items) {
	$("#dynTitulosGrid").html("<table id='tituloGird'></table><div id='tituloGirdPager'></div>");
	var me = this;
	me.grid = $("#" + me.gridId).jqGrid({
		data: items,
		datatype: "local",
		loadonce: true,
		colModel: me.columns,
		viewrecords: false,
		shrinkToFit: false,
		width: 1000,
		height: 250,
		rowNum: 10000,
		onSelectRow: function(id) {
			var _t = jQuery("#" + me.gridId).getRowData(id);
			if (_t.idTituloCnt == '') {
				$("#" + me.gridId).jqGrid('setSelection', id, false);
			}
		},
		loadComplete: function(data) {
			$("#" + me.gridId + ' tbody  tr#1 > td').css({ 'font-weight': 'bold', 'background-color': '#ffffcc' });
			$("#" + me.gridId + '_frozen tbody  tr#1 > td').css({ 'font-weight': 'bold', 'background-color': '#ffffcc' });
			$("#" + me.gridId + ' tbody  tr#1 > td').css({ 'font-weight': 'bold', 'padding-left': '1px' });
			$("#" + me.gridId + '_frozen tbody  tr#1 > td').css({ 'font-weight': 'bold', 'padding-left': '1px' });
		}
	});
	$("#" + me.gridId).jqGrid('setFrozenColumns');
};
