/*******************************************************************************
 * ************************************************************************
 * Excel Mapper
 * ************************************************************************
 * Transforma una tabla a un objeto son y lo serializa para ser enviado a un
 * action donde se transformara en un excel
 * ***********************************************************************
 * Requiere -jquery.js -tableToJson.js
 * 
 ******************************************************************************/

(function($) {

	$.excelMapper = function(element, options) {

		var s = this;
		s.settings = {};

		// CONSTRUCTOR
		s.construct = function() {
			s.settings = $.extend(true, {}, $.fn.excelMapper.defaults, options);
			s.settings.id = element.attr('id');
		};

		// PUBLIC METHODS
		s.send = function() {
			var param = {};
			param[s.settings.rootRows] = $('#' + s.settings.id).tableToJSON(s.settings.toJSONConfig);

			var toSend = {};
			toSend[s.settings.actionAttribute] = JSON.stringify(param);
			var data = $.extend(true, {}, s.settings.data, toSend);

			$.ajax({
				url : s.settings.action,
				type : 'post',
				data : data,
				async : false,
				dataType  : 'html',
				success : function(ret) {
					window.location = s.settings.action ;
					if (s.settings.onSucces != null) {
						s.settings.onSucces(ret);
					}
				},
				'error' : function(jqXHR, textStatus, errorThrown) {
					if (s.settings.onError != null) {
						s.settings.onError(jqXHR, textStatus, errorThrown);
					}
				}
			});
		};

		s.construct();
		return s;

	};

	$.fn.excelMapper = function(options) {
		var dt = new $.excelMapper(this, options);
		return dt;
	};

	$.fn.excelMapper.defaults = {
		id : null,
		action : "",
		actionAttribute : "table",
		rootRows : "",
		data : {},
		toJSONConfig : {},
		onSucces : null,
		onError : null
	};

}(jQuery));