package com.mx.dla.dda.contrato.generales.bos;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.contrato.generales.daos.ValidacionGeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.ws.dtos.ItemOrdenCompraDTO;
import com.mx.dla.dda.contrato.ws.dtos.ItemPosicionDTO;
import com.mx.dla.dda.contrato.ws.dtos.ParamAdendumEnmiendaDTO;
import com.mx.dla.dda.contrato.ws.dtos.ParamOrdenCompraDTO;
import com.mx.dla.global.bos.BaseBO;

@Component
public class ParametersWebService extends BaseBO{
	
	@Autowired
	private ValidacionGeneralesDAO validacionGeneralesDAO;
	
	@Value("${adendumEnmienda.idPosicion}")
	private String idPosicionAdEn;
	
	@Value("${ordenInterna.idPosicion}")
	private String idPosicionOrdInt;
	
	@Value("${ordenInterna.idMaterial.suscripcion}")
	private String idMaterialSuscripcion;
	
	@Value("${ordenInterna.idMaterial.transaccines}")
	private String idMaterialTransaccion;
	
	@Value("${ordenInterna.idMaterial.licenseFee}")
	private String idMaterialLicense;
	
	@Value("${ordenInterna.centro}")
	private String centroOrdInt;
	
	@Value("${ordenInterna.precio}")
	private String precioOrdInt;
	
	@Value("${ordenInterna.indicadorIva}")
	private String indicadorIvaOrdInt;
	
	@Value("${ordenInterna.tipoImputacion.siAmortizable}")
	private String tipoInputacionSiAmortizableOrdInt;
	
	@Value("${ordenInterna.tipoImputacion.noAmortizable}")
	private String tipoInputacionNoAmortizableOrdInt;
	
	@Value("${ordenInterna.idPosicionAcc}")
	private String idPosicionAccOrdInt;
	
	@Value("${ordenInterna.centroCostos}")
	private String centroCostosOrdInt;
	
	@Value("${ordenInterna.idOrden}")
	private String idOrdenOrdInt;
	
	@Value("${ordenInterna.sociedad}")
	private String sociedadOrdInt;
	
	@Value("${ordenInterna.claseDoc.t}")
	private String claseDocTOrdInt;
	
	@Value("${ordenInterna.claseDoc.a}")
	private String claseDocAOrdInt;
	
	@Value("${ordenInterna.claseDoc.na}")
	private String claseDocNaOrdInt;
	
	@Value("${ordenInterna.orgCompras}")
	private String orgComprasOrdInt;
	
	@Value("${ordenInterna.grupoCompras}")
	private String grupoComprasOrdInt;
	
	
	public ParamOrdenCompraDTO obtenParametroOrdenCompra(ContratoDTO contrato, String expediente){
		
            ItemOrdenCompraDTO itemDTO = new ItemOrdenCompraDTO();
            List<ItemOrdenCompraDTO> listItemDTO = new ArrayList<ItemOrdenCompraDTO>();
            ParamOrdenCompraDTO paramDTO = new ParamOrdenCompraDTO();
            SimpleDateFormat formatoDeFecha = new SimpleDateFormat("dd.MM.yyyy");
            Double cantidad;

            boolean amortizable = false;

            if(contrato.getAmortizable().equals("SI")){
                    amortizable = true;
            }

            logger.debug("Amortizable: " + amortizable);

            itemDTO.setIdPosicion(idPosicionOrdInt);// = "00010"

            if(contrato.getIdTipoContrato() == 1) {
                    itemDTO.setIdMaterial(idMaterialSuscripcion);
            }else if(contrato.getIdTipoContrato() == 2) {
                    itemDTO.setIdMaterial(idMaterialTransaccion);
            }else {
                    itemDTO.setIdMaterial(idMaterialLicense);
            }


            itemDTO.setCentro(centroOrdInt);// = "NT07" 

            cantidad  = validacionGeneralesDAO.obtenCantidad(contrato.getIdContrato());

            logger.info("cantidad : " + cantidad);

            if( contrato.getIdTipoContrato() == 1 || contrato.getIdTipoContrato() == 3 )//Si es suscripcin o License Fee
            { 
                if(cantidad != null){
                	//RFD se agrega la cantidad al precio y el precio a la cantidad, se intercambia por solicitud de SAP
                	itemDTO.setCantidad(String.format("%.2f", cantidad));// SUMA DE LOS VALORES DE TITULOS
                	//itemDTO.setCantidad("1");
                }else{
                    itemDTO.setCantidad("1");
                }
            }
            else{	//  Si es Transaccional 
                    itemDTO.setCantidad("1");
            }


            //--- Para Suscripcin y Licenses fee por definicin se envia 1.
            //--- Para Transaccional se acordo enviar 1 para no tener que manejar el monto por minimo garantizado
            //RFD se agrega la cantidad al precio y el precio a la cantidad, se intercambia por solicitud de SAP
            itemDTO.setPrecio("1");
            //itemDTO.setPrecio(String.format("%.2f", cantidad));

            itemDTO.setIndicadorIVA(contrato.getClaveIva());// = "U0" verifivar cuando U1 || U9 SOS

            if(amortizable) {// si amortizable = F, !amortizable = K 
                itemDTO.setTipoImputacion(tipoInputacionSiAmortizableOrdInt);
            }else {
                itemDTO.setTipoImputacion(tipoInputacionNoAmortizableOrdInt);   
            }

            itemDTO.setIdPosicionAcc(idPosicionAccOrdInt);// = "00010"

            if(amortizable) { // si amortizable = null, !amortizable = 07A01US501 
                itemDTO.setCentroCostos("");
            }else {
                itemDTO.setCentroCostos(centroCostosOrdInt);
            }

            if(amortizable) {// si amortizable = orden interna idSap de DDA_T_APARTADO, !amortizable = null SOS
                itemDTO.setIdOrden(validacionGeneralesDAO.obtenerIdSapApartado(contrato.getIdApartado()));// = "000000400098")
            }else {
                itemDTO.setIdOrden("");
            }

            listItemDTO.add(itemDTO);

            paramDTO.setSociedad(sociedadOrdInt);// = "NT07"

            if(contrato.getIdTipoContrato() == 2) {// si tipoContrato = T = NT08 
                paramDTO.setClaseDoc(claseDocTOrdInt);//"NT08"
            }else{//!T (S & L) amortizable si = NT06 ? no = NT07
                if(amortizable) {
                    paramDTO.setClaseDoc(claseDocAOrdInt);//="NT06"
                }else {
                    paramDTO.setClaseDoc(claseDocNaOrdInt);//="NT07"
                }
            }

            paramDTO.setIdProveedor(validacionGeneralesDAO.obtenIdProveedor(contrato.getIdEstudio()).toString());// "0030800000"  idSap estudio SOS
            paramDTO.setOrgCompras(orgComprasOrdInt);// = "US01"
            paramDTO.setGrupoCompras(grupoComprasOrdInt);// = "Z01"
            paramDTO.setFechaDoc(formatoDeFecha.format(new Date())); // now, format "07.10.2015"
            paramDTO.setReferencia(contrato.getNumeroContrato());// nmero de contrato |10|
            paramDTO.setIdContrato(contrato.getIdContrato().toString());
            paramDTO.setExpediente(expediente);
            paramDTO.setItems(listItemDTO);

            //log.debug("Nmero de contrato: " + contrato.getNumeroContrato().substring(0, 10) + paramDTO.toString());

            return paramDTO;
	}

	public ParamAdendumEnmiendaDTO obtenParametroEnmienda(ContratoDTO contrato, String expediente){
		
		ItemPosicionDTO 		itemDTO = new ItemPosicionDTO();
		List<ItemPosicionDTO> 	listItemDTO = new ArrayList<ItemPosicionDTO>();
		ParamAdendumEnmiendaDTO paramDTO = new ParamAdendumEnmiendaDTO();
		
		Date fechaModificaSAP = contrato.getFechaModificaSAP();
		boolean modifica = false;
		Double cantidadP = 0.0, cantidadH = 0.0;
		String ordenInterna;
		
		cantidadP = validacionGeneralesDAO.obtenCantidad(contrato.getIdContratoOriginal());
		cantidadH = validacionGeneralesDAO.obtenCantidad(contrato.getIdContrato());
		
		ordenInterna = validacionGeneralesDAO.obtenerIdSapApartado(contrato.getIdApartado());
		
		if(fechaModificaSAP == null) {
	
			if (cantidadP != null && cantidadH != null) {
				if((cantidadP - cantidadH) != 0) {
					modifica = true;
				}
			}else {
				//cantidadH = 1.5; ///Quitarlo, es solo para pruebas
				logger.debug("cantidadH en hardcode : " + cantidadH);
			}
			
		}
		
		logger.debug("cantidadP = " + cantidadP + " cantidadH = " + cantidadH + " modifica : " + modifica + " posicion : " + idPosicionAdEn);
		
		itemDTO.setPosicion(idPosicionAdEn);//"00010");
		
		itemDTO.setCantidad(cantidadH.toString());//"1250"); //suma de ttulos del clonado buscar idAnt obtener cantidad
		
		listItemDTO.add(itemDTO);
				
		
		paramDTO.setIdContrato(contrato.getIdContrato().toString()); //"20"
		paramDTO.setIdSAP(contrato.getIdSap());//"9200000009"		
		paramDTO.setExpediente(expediente);//"solvera"
		paramDTO.setProveedor(validacionGeneralesDAO.obtenIdProveedor(contrato.getIdEstudio()).toString());// "0030800000"  idSap estudio SOS
		paramDTO.setClaveIVA(contrato.getClaveIva());
		paramDTO.setOrdenInterna( ordenInterna );
		
		return paramDTO;
	}
	
	/*
	public ParamAdendumEnmiendaDTO obtenParametroAdendumEnmienda(ContratoDTO contrato, String expediente){
		ItemPosicionDTO itemDTO = new ItemPosicionDTO();
		List<ItemPosicionDTO> listItemDTO = new ArrayList<ItemPosicionDTO>();
		ParamAdendumEnmiendaDTO paramDTO = new ParamAdendumEnmiendaDTO();
		
		Date fechaModificaSAP = contrato.getFechaModificaSAP();
		boolean modifica = false;
		Double cantidadP = 0.0, cantidadH = 0.0;
		String ordenInterna;
		
		cantidadP = validacionGeneralesDAO.obtenCantidad(contrato.getIdContratoOriginal());
		cantidadH = validacionGeneralesDAO.obtenCantidad(contrato.getIdContrato());
		
		ordenInterna = validacionGeneralesDAO.obtenerIdSapApartado(contrato.getIdApartado());
		
		if(fechaModificaSAP == null) {
	
			if (cantidadP != null && cantidadH != null) {
				if((cantidadP - cantidadH) != 0) {
					modifica = true;
				}
			}else {
				cantidadH = 1.5; ///Quitarlo, es solo para pruebas
				logger.debug("cantidadH en hardcode : " + cantidadH);
			}
			
		}
		
		logger.debug("cantidadP = " + cantidadP + " cantidadH = " + cantidadH + " modifica : " + modifica + " posicion : " + idPosicionAdEn);
		
		itemDTO.setPosicion(idPosicionAdEn);//"00010");
		
		itemDTO.setCantidad(cantidadH.toString());//"1250"); //suma de ttulos del clonado buscar idAnt obtener cantidad
		
		listItemDTO.add(itemDTO);
				
		
		paramDTO.setIdContrato(contrato.getIdContrato().toString()); //"20"
		paramDTO.setIdSAP(contrato.getIdSap());//"9200000009"		
		paramDTO.setExpediente(expediente);//"solvera"
		paramDTO.setProveedor(validacionGeneralesDAO.obtenIdProveedor(contrato.getIdEstudio()).toString());// "0030800000"  idSap estudio SOS
		paramDTO.setClaveIVA(contrato.getClaveIva());
		paramDTO.setOrdenInterna( ordenInterna );
		
		return paramDTO;
	}
	*/
	/*
	public ParamOrdenCompraDTO obtenParametroOrdenCompra(ContratoDTO contrato, String expediente){
		
		ItemOrdenCompraDTO itemDTO = new ItemOrdenCompraDTO();
		List<ItemOrdenCompraDTO> listItemDTO = new ArrayList<ItemOrdenCompraDTO>();
		ParamOrdenCompraDTO paramDTO = new ParamOrdenCompraDTO();
		SimpleDateFormat formatoDeFecha = new SimpleDateFormat("dd.MM.yyyy");
		Double cantidad;
		
		boolean amortizable = false;
		
		if(contrato.getAmortizable().equals("SI")){
			amortizable = true;
		}
		
		logger.debug("Amortizable: " + amortizable);
		
		itemDTO.setIdPosicion(idPosicionOrdInt);// = "00010"
		
		if(contrato.getIdTipoContrato() == 1) {
			itemDTO.setIdMaterial(idMaterialSuscripcion);
		}else if(contrato.getIdTipoContrato() == 2) {
			itemDTO.setIdMaterial(idMaterialTransaccion);
		}else {
			itemDTO.setIdMaterial(idMaterialLicense);
		}
		
		
		
		itemDTO.setCentro(centroOrdInt);// = "NT07" 
		
		cantidad  = validacionGeneralesDAO.obtenCantidad(contrato.getIdContrato());
		
		logger.info("cantidad : " + cantidad);

		if( contrato.getIdTipoContrato() == 1 || contrato.getIdTipoContrato() == 3 )//Si es suscripcin o License Fee
		{ 
			if(cantidad != null){
				itemDTO.setCantidad(String.format("%.2f", cantidad));// SUMA DE LOS VALORES DE TITULOS
			}
			else{
				itemDTO.setCantidad("1");
			}
		}
		else{	//  Si es Transaccional 
			itemDTO.setCantidad("1");
		}
		
		
		//--- Para Suscripcin y Licenses fee por definicin se envia 1.
		//--- Para Transaccional se acordo enviar 1 para no tener que manejar el monto por minimo garantizado
		itemDTO.setPrecio("1");
		
		
		itemDTO.setIndicadorIVA(contrato.getClaveIva());// = "U0" verifivar cuando U1 || U9 SOS
		
		if(amortizable) {// si amortizable = F, !amortizable = K 
			itemDTO.setTipoImputacion(tipoInputacionSiAmortizableOrdInt);
		}else {
			itemDTO.setTipoImputacion(tipoInputacionNoAmortizableOrdInt);   
		}
		
		itemDTO.setIdPosicionAcc(idPosicionAccOrdInt);// = "00010"
		
		if(amortizable) { // si amortizable = null, !amortizable = 07A01US501 
			itemDTO.setCentroCostos("");
		}else {
			itemDTO.setCentroCostos(centroCostosOrdInt);
		}
		
		if(amortizable) {// si amortizable = orden interna idSap de DDA_T_APARTADO, !amortizable = null SOS
			itemDTO.setIdOrden(validacionGeneralesDAO.obtenerIdSapApartado(contrato.getIdApartado()));// = "000000400098")
		}else {
			itemDTO.setIdOrden("");
		}
		
		
		listItemDTO.add(itemDTO);
		
		paramDTO.setSociedad(sociedadOrdInt);// = "NT07"
		
		if(contrato.getIdTipoContrato() == 2) {// si tipoContrato = T = NT08 
			paramDTO.setClaseDoc(claseDocTOrdInt);//"NT08"
		}else{//!T (S & L) amortizable si = NT06 ? no = NT07
			if(amortizable) {
				paramDTO.setClaseDoc(claseDocAOrdInt);//="NT06"
			}else {
				paramDTO.setClaseDoc(claseDocNaOrdInt);//="NT07"
			}
		}
		
		//logger.info("");
		paramDTO.setIdProveedor(validacionGeneralesDAO.obtenIdProveedor(contrato.getIdEstudio()).toString());// "0030800000"  idSap estudio SOS
		paramDTO.setOrgCompras(orgComprasOrdInt);// = "US01"
		paramDTO.setGrupoCompras(grupoComprasOrdInt);// = "Z01"
		paramDTO.setFechaDoc(formatoDeFecha.format(new Date())); // now, format "07.10.2015"
		paramDTO.setReferencia(contrato.getNumeroContrato());// nmero de contrato |10|
		paramDTO.setIdContrato(contrato.getIdContrato().toString());
		paramDTO.setExpediente(expediente);
		paramDTO.setItems(listItemDTO);
		
		//log.debug("Nmero de contrato: " + contrato.getNumeroContrato().substring(0, 10) + paramDTO.toString());
		
		return paramDTO;
	}
*/

}
