package com.mx.dla.dda.reporte.pago.actions;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.addons.bos.EstudioAddonBO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.PoblarGeneralesBO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

public class ReportePagoAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private List<EstudioDTO> estudios;
	private List<EstudioAddonDTO> estudiosAddon;
	private String fechaInicio;
	private String fechaFin;

	@Autowired
	private PoblarGeneralesBO poblarGeneralesBO;

	@Autowired
	private EstudioAddonBO estudioAddonBO;

	public String execute() throws TransaccionException {
		try {
			setEstudiosAddon(estudioAddonBO.getEstudios());
			setEstudios(poblarGeneralesBO.obtenListaEstudios());
			setFechaInicio(poblarGeneralesBO.formateaFecha(new Date()));
			setFechaFin(poblarGeneralesBO.formateaFecha(new Date()));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public void setEstudios(List<EstudioDTO> estudios) {
		this.estudios = estudios;
	}

	public List<EstudioDTO> getEstudios() {
		return estudios;
	}

	public List<EstudioAddonDTO> getEstudiosAddon() {
		return estudiosAddon;
	}

	public void setEstudiosAddon(List<EstudioAddonDTO> estudiosAddon) {
		this.estudiosAddon = estudiosAddon;
	}

	public String getFechaInicio() {
		return fechaInicio;
	}

	public void setFechaInicio(String fechaInicio) {
		this.fechaInicio = fechaInicio;
	}

	public String getFechaFin() {
		return fechaFin;
	}

	public void setFechaFin(String fechaFin) {
		this.fechaFin = fechaFin;
	}

}
