package com.mx.dla.dda.reporte.pago.actions;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.reporte.pago.bos.ReportePagoBO;
import com.mx.dla.dda.reporte.pago.dtos.ReportePagoDTO;
import com.mx.dla.dda.reporte.pago.dtos.ReporteRowDTO;

public class ReportePagoInfoAction extends BaseContratoAction {
	private static final long serialVersionUID = 1L;

	private Long idCon;
	private Date fechaInicio;
	private Date fechaFin;
	private String[] llaves;
	private List<ReportePagoDTO> infoReporte;
	private Long idEstudio;
	private List<ReporteRowDTO> reporte;
	private String[] encabezado;

	@Autowired
	private ReportePagoBO reportePagoBO;

	public String execute() {
		setEncabezado(reportePagoBO.obtenerEncabezado(fechaInicio));
		reporte = reportePagoBO.obteneReporte(fechaInicio, idCon, idEstudio);
		return SUCCESS;
	}

	public void setIdCon(Long idCon) {
		this.idCon = idCon;
	}

	public Long getIdCon() {
		return idCon;
	}

	public void setFechaInicio(Date fechaInicio) {
		this.fechaInicio = fechaInicio;
	}

	public Date getFechaInicio() {
		return fechaInicio;
	}

	public void setFechaFin(Date fechaFin) {
		this.fechaFin = fechaFin;
	}

	public Date getFechaFin() {
		return fechaFin;
	}

	public void setLlaves(String[] llaves) {
		this.llaves = llaves;
	}

	public String[] getLlaves() {
		return llaves;
	}

	public void setInfoReporte(List<ReportePagoDTO> infoReporte) {
		this.infoReporte = infoReporte;
	}

	public List<ReportePagoDTO> getInfoReporte() {
		return infoReporte;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setReporte(List<ReporteRowDTO> reporte) {
		this.reporte = reporte;
	}

	public List<ReporteRowDTO> getReporte() {
		return reporte;
	}
	
	public void setEncabezado(String[] encabezado) {
		this.encabezado = encabezado;
	}
	
	public String[] getEncabezado() {
		return encabezado;
	}
}
