function TituloGrid(gridId) {
	this.gridId  = gridId;
	this.grid    = null ;
	var me       = this;
	this.columns = [                 	
                 	{ label: 'idTituloCnt'  , name: 'idTituloCnt', width: 250, frozen:true, hidden:true     },
                    { label: 'Filial'       , name: 'filial'     , width: 100, frozen:true, sortable: false, hidden:true },
                    { label: 'Id Bv' ,        name: 'idBv'       , width: 100, frozen:true, sortable: false },
                    { label: 'Nombre', width:200 , frozen:true, sortable: false, 
                 		formatter : function (cellvalue, options, rowObject) {
                 			var r = cellvalue;
             			    if(rowObject.agrupable != null && rowObject.agrupable == '0' )
                 			{             			    	
                 				r = "<a href='javascript:tituloController.cargaTitulosInicial()'><strong>"+rowObject.nombreTotalSer+"</strong></a> "
                 			}
                 			if(rowObject.agrupable != null && rowObject.agrupable == '1' )
                 			{
                 				r = "<a href='javascript:tituloController.cargaTitulosSeries(\""+rowObject.nombreUnico+"\")'><strong>"+rowObject.nombreTotalSer+"</strong></a> "
                 			}
                 			if(rowObject.agrupable != null && rowObject.agrupable == '2' )
                 			{
                 				r = "<a href='javascript:tituloController.cargaTitulosDetalle(\""+rowObject.nombreUnico+"\", \""+rowObject.idBv+"\")'><strong>"+rowObject.nombreTotalSer+"</strong></a> "
                 			}
                 			if(rowObject.agrupable != null && rowObject.agrupable == '3' )
                 			{
                 				r = rowObject.filial
                 			}                 			
                 			return r;
                 		}
                    },
                    { label: 'Nombre Estandar' , name: 'nombreEstandar', width:200  , frozen:false, sortable: false, hidden:true },
                    { label: 'Categor&iacute;a', name: 'categoria'     , width: 150 , frozen:false, sortable: false },                                        
                    { label: 'Temporada'       , name: 'temporada'     , width: 80  , frozen:false, sortable: false },
                    { label: 'Episodio'        , name: 'episodio'      , width: 80  , frozen:false, sortable: false },
                    { label: 'HVDR'            , name: 'hvrd'          , width: 100 , frozen:false, formatter:'date', formatoptions: {  newformat: 'm/d/Y'} },
                    { label: 'Inicio'          , name: 'fechaInicio'   , width: 100 , frozen:false, formatter:'date', formatoptions: {  newformat: 'm/d/Y'} },
                    { label: 'Fin'             , name: 'fechaFin'      , width: 100 , frozen:false, formatter:'date', formatoptions: {  newformat: 'm/d/Y'} },
                    { label: 'Release'         , name: 'release'       , width: 120 , frozen:false, formatter:'number',formatoptions:{decimalSeparator:".", thousandsSeparator: ",", decimalPlaces: 2}, hidden:true },
                    { label: '% RS'            , name: 'revenueShare'  , width: 120 , frozen:false, formatter:'number',formatoptions:{decimalSeparator:".", thousandsSeparator: ",", decimalPlaces: 2}, hidden:true },
                    { label: 'Box Office ($)'  , name: 'boxOffice'     , width: 120 , frozen:false, formatter:'number',formatoptions:{decimalSeparator:".", thousandsSeparator: ",", decimalPlaces: 2} },
                    { label: 'Categor&iacute;a MG',name: 'categoriaMG' , width: 150 , frozen:false, sortable: false, hidden:true },
                    { label: 'MG'              , name: 'mg'            , width: 120 , frozen:false, formatter:'number',formatoptions:{decimalSeparator:".", thousandsSeparator: ",", decimalPlaces: 2}, hidden:true },
                    { label: 'Categor&iacute;a DTR',name: 'categoriaDTR', width: 150, sortable: false },
                    { label: 'Categor&iacute;a DTO',name: 'categoriaDTO', width: 150, sortable: false },
                    { label: 'Briefcase'       , name: 'briefcase'     , width: 100 , align:"center",  jsonmap:'briefcase', formatter : me.renderCheckBox, sortable: false  },
                    { label: 'DTR'             , name: 'dtr'           , width: 100 , align:"center",  jsonmap:'dtr'      , formatter : me.renderCheckBox, sortable: false  },
                    { label: 'DTO'             , name: 'dto'           , width: 100 , align:"center",  jsonmap:'dto'      , formatter : me.renderCheckBox, sortable: false  },
                    { label: 'SD'              , name: 'sd'            , width: 100 , align:"center",  jsonmap:'sd'       , formatter : me.renderCheckBox, sortable: false  },
                    { label: 'HD'              , name: 'hd'            , width: 100 , align:"center",  jsonmap:'hd'       , formatter : me.renderCheckBox, sortable: false  },
                    { label: '3D'              , name: 'tresd'         , width: 100 , align:"center",  jsonmap:'tresd'    , formatter : me.renderCheckBox, sortable: false  },
                    { label: 'Duracion'        , name: 'duracion'      , width: 150, sortable: false },
                    { label: 'A&ntilde;o'      , name: 'anio'          , width: 150, sortable: false },
                    { label: 'Genero'          , name: 'genero'        , width: 150, sortable: false },
                    { label: 'Genero B'        , name: 'generoB'       , width: 150, sortable: false }, 
                    { label: 'Nombre espa&ntilde;ol' , name: 'nombreEnEspaniol', width:200  , frozen:false, sortable: false},
                    { label: 'Nombre ingl&eacute;s' , name: 'nombreEnIngles', width:200  , frozen:false, sortable: false},
                    { label: 'Nombre portugu&eacute;s' , name: 'nombreEnPortugues', width:200  , frozen:false, sortable: false},
                    { label: 'agrupable'       , name: 'agrupable'     , width: 250 ,  hidden:true },
                    { label: 'movieSerie'      , name: 'movieSerie'    , width: 200 ,  hidden:true  },
                    { label: 'idSap'           , name: 'idSap'         , width: 200 ,  hidden:true  },
                    { label: 'Categoria Serie' , name: 'categoriaSerie', width: 150 ,  hidden:true },
                    { label: 'Tier           ' , name: 'tier'          , width: 150 ,  hidden:true},
                 	{ label: 'NombreUnico', name: 'nombreUnico', width: 250, frozen:true, hidden:true}

                ];				
}

TituloGrid.prototype.init = function(items) {
	var me = this;
	me.grid = $("#"+me.gridId).jqGrid({
		data        : items,
        datatype    : "local",
        loadonce    : true,
        colModel    : me.columns,
        width       : 1000 ,
        height      : 250,
        rowNum      : 10000,
		viewrecords : false,
		shrinkToFit :false,		
        multiselect : true,        
        onSelectRow : function (id)
        {
        	var _t = jQuery("#"+me.gridId).getRowData(id);
        	if(_t.idTituloCnt == '')        	
        	   $("#"+me.gridId).jqGrid('setSelection', id, false);
        	
        },
        loadComplete: function(data) {
        	$( "#"+me.gridId + ' tbody  tr#1 > td')       .css( { 'font-weight':'bold', 'background-color':'#ffffcc' } );
        	$( "#"+me.gridId + '_frozen tbody  tr#1 > td').css( { 'font-weight':'bold', 'background-color':'#ffffcc' } );
			$( "#"+me.gridId + ' tbody  tr#1 > td')       .css( { 'font-weight':'bold', 'padding-left':'1px' } );
			$( "#"+me.gridId + '_frozen tbody  tr#1 > td').css( { 'font-weight':'bold', 'padding-left':'1px' } );														
        }
    });
	$("#"+me.gridId).jqGrid('setFrozenColumns');
};


TituloGrid.prototype.getColumns = function() {
	return this.columns;
};

TituloGrid.prototype.reload = function() {
	this.genericLoadData( this.getData );
};

TituloGrid.prototype.genericLoadData = function( loadData  , nu) {
	var me = this;
	$("#dynTitulosGrid").html("<table id='tituloGird'></table><div id='tituloGirdPager'></div>");
	var items = loadData(nu);
	this.init(items);
}



TituloGrid.prototype.getData =function(  ) { 
	var items = [];
	$.ajax({ 
		url : contextPath +'/contrato/transaccion/titulo/obtenerTitulos.action',
		type : "post",
		data : {"idLista" : idLista  },
		async : false,
		success : function (ret) 
		{ 
			items = ret.titulos;			 
		}
	});
	return items;
};

TituloGrid.prototype.renderCheckBox = function (cellvalue, options, rowObject){  			
	var r = "<input type='checkbox' disabled='disabled'" ;
	if(cellvalue || cellvalue == "1") { r+= " checked='checked' "; }
    r+=" />";
	return r; 
};

TituloGrid.prototype.itemsSelected = function() {
	var me  = this;
	var ret = [];		
	
	var rowId = $("#"+me.gridId).jqGrid('getGridParam','selarrrow');
	
	rowId.forEach(function (e,i){
		var _t = jQuery("#"+me.gridId).getRowData(e);		
		var _a = me.row2Titulo(_t);
		
		if(_a.idTituloCnt != "")
		   ret.push(_a);
	});	
		
	return ret;	
};

TituloGrid.prototype.getRows = function(rowId) {
	var me  = this;
	var row =  $("#"+me.gridId).jqGrid('getRowData', rowId);			
	return row;	
};

TituloGrid.prototype.row2Titulo = function(fila) {
	
		var briefcase = String(fila.briefcase).search("checked") == -1 ? false : true;
		var dtr       = String(fila.dtr).search("checked")       == -1 ? false : true;
		var dto       = String(fila.dto).search("checked")       == -1 ? false : true;
		var sd        = String(fila.sd).search("checked")        == -1 ? false : true;
		var hd        = String(fila.hd).search("checked")        == -1 ? false : true;
		var tresd     = String(fila.tresd).search("checked")     == -1 ? false : true;
	  
		var titulo = {
					idTituloCnt : fila.idTituloCnt,
					filial      : fila.filial,
					idBv        : fila.idBv,				
					nombreUnico : fila.nombreUnico,								
					nombreEstandar: fila.nombreEstandar,
					categoria   : fila.categoria,
					temporada   : fila.temporada,
					episodio    : fila.episodio,
					fechaFin    : fila.fechaFin,
					fechaInicio : fila.fechaInicio,
					hvrd        : fila.hvrd,								
					boxOffice   : fila.boxOffice,				
					categoriaSerie: fila.categoriaSerie,
					tier        : fila.tier,
					categoriaDTR: fila.categoriaDTR,
					briefcase   : briefcase,
					dtr         : dtr,
					dto         : dto,
					sd          : sd,
					hd          : hd,
					tresd       : tresd,
					duracion    : fila.duracion,
					anio        : fila.anio,
					genero      : fila.genero,
					generoB     : fila.generoB,
					idFila      : $("#idFila").val(),
					nombreEnEspaniol: fila.nombreEnEspaniol,
					nombreEnIngles:   fila.nombreEnIngles,
					nombreEnPortugues : fila.nombreEnPortugues
				};	
		return titulo;
};

TituloGrid.prototype.getDetails = function( nombreUnico ) { 
	var items = {};	
	$.ajax({ 
		url : contextPath +'/contrato/transaccion/titulo/obtenerTitulosSeries.action',
		type : "post",
		data : {	"idLista"  : idLista,
					"titulo"   : nombreUnico
				},
		async : false,
		success : function (ret) 
		{ 
			items = ret.titulos; 			 
		}
	});
	var me = this;
	$("#dynTitulosGrid").html("<table id='tituloGird'></table><div id='tituloGirdPager'></div>");
	this.init(items);
};

TituloGrid.prototype.getPrincipal = function() { 
	var items = {};	
	$.ajax({ 
		url : contextPath +'/contrato/transaccion/titulo/listadoTitulosPrincipal.action',
		type : "post",
		data : {	"idLista"  : idLista
				},
		async : false,
		success : function (ret) 
		{ 
			items = ret.titulos; 			 
		}
	});
	var me = this;
	$("#dynTitulosGrid").html("<table id='tituloGird'></table><div id='tituloGirdPager'></div>");
	this.init(items);
};

TituloGrid.prototype.getSeries = function( nombreUnico ) { 
	var items = {};	
	$.ajax({ 
		url : contextPath +'/contrato/transaccion/titulo/listadoTitulosSeries.action',
		type : "post",
		data : {	"idLista"  : idLista,
					"titulo"   : nombreUnico
				},
		async : false,
		success : function (ret) 
		{ 
			items = ret.titulos; 			 
		}
	});
	var me = this;
	$("#dynTitulosGrid").html("<table id='tituloGird'></table><div id='tituloGirdPager'></div>");
	this.init(items);
};

TituloGrid.prototype.getDetalles = function( nombreUnico, idBv ) { 
	var items = {};	
	$.ajax({ 
		url : contextPath +'/contrato/transaccion/titulo/listadoTitulosDetalle.action',
		type : "post",
		data : {	"idLista"  : idLista,
					"titulo"   : nombreUnico,
					"idBv"     : idBv
				},
		async : false,
		success : function (ret) 
		{ 
			items = ret.titulos; 			 
		}
	});
	var me = this;
	$("#dynTitulosGrid").html("<table id='tituloGird'></table><div id='tituloGirdPager'></div>");
	this.init(items);
};