function generaTabla(data, aprobada){	
	var facturaDetalleTamanio = data.factura.contratos.length;
	
	if(facturaDetalleTamanio > 0)
	   $('#botonGuardar').attr('disabled', false);
    generarTabla2(data.factura.contratos);
    
    if($("input[name='factura.approved']:checked").val() == "1")
    {
    	$("table td input").attr("readonly", true);
    	$("table td input[type='checkbox']").hide();
    	$("table td button").hide();
    }    	
}

function generarTabla2(contratos){				
	var tabla = $("<table/>").attr("id","tFacturaDetalle2").addClass("table factura");
	var encabezado = crearEncabezado2();
	var cuerpo     = $("<tbody/>");
			
	for(var i=0; i< contratos.length; i++)
	{		
		cuerpo.append(crearFilaContrato(contratos[i].idContrato,contratos[i].contratoDesc, 
				                        contratos[i].total, contratos[i].pagado, contratos[i].pendiente, contratos[i].pagar, contratos[i].idSapCto));
				
		for(var j=0; j< contratos[i].meses.length; j++)
		{
			agregarValoresIniciales(contratos[i].idContrato, contratos[i].meses[j].mes, contratos[i].meses[j].pagar);
			cuerpo.append(crearFilaMes(contratos[i].idContrato, contratos[i].meses[j].mes, contratos[i].idContratoOri, contratos[i].meses[j].nuevo,  
					                   contratos[i].meses[j].total, contratos[i].meses[j].pagado, contratos[i].meses[j].pendiente, contratos[i].meses[j].pagar));										
		}
	}			
	
	tabla.append(encabezado).append(cuerpo);	
	$("#tablaFacturaDetalle").append(tabla);
	$("#tFacturaDetalle2 tr.accordion-body").collapse('toggle');
}

function agregarValoresIniciales(idCto, mes, valor){
	valorA = {id: idCto+"-"+mes, valor : parseFloat(valor)}
	montosIniciales.push(valorA);
}

function crearEncabezado2(){	
	var fila = $("<tr/>").addClass("encabezado")
				.append($("<th/>").text("Concepto"))
				.append($("<th/>").text(""))
				.append($("<th/>").text("Total"))
				.append($("<th/>").text("Pagado"))
				.append($("<th/>").text("Pendiente"))
				.append($("<th/>").text(""))
				.append($("<th/>").text("A Pagar"));
	return $("<thead/>").append(fila);			    		
}

function crearFilaContrato(id, descripcion, total, pagado, pendiente, pagar, sap){
	
	var boton = $("<button class='btn btn-xs'/>").attr("type","button").attr("idCto",id).text(">>")
                .click(function() {                				                
                moverPendienteaPagar($(this).attr("idCto"), $(this).attr("mes"));
			    sumarFilas("trMes"     , $(this).attr("idCto"), $(this).attr("mes"));
			    sumarFilas("trContrato", $(this).attr("idCto"), $(this).attr("mes"));			    			    			   
	});

	var fila = $("<tr/>").attr("id","idC-"+id).attr("data-bs-toggle", "collapse").attr("data-bs-target",".packageDetails"+id)
	                     .attr("sap",sap)
	                     .addClass("trContrato accordion-toggle")
	            .append($("<td/>").append("<ins>"+descripcion+"</ins>"))
				.append($("<td/>"))
				.append($("<td/>").text(formatCurrency(Number(unformatCurrency(total)), 4)))
				.append($("<td/>").text(formatCurrency(Number(unformatCurrency(pagado)), 4)))
				.append($("<td/>").text(formatCurrency(Number(unformatCurrency(pendiente)), 4)))
				.append($("<td class='' />").append(boton))
				.append($("<td/>").text(formatCurrency(Number(unformatCurrency(pagar)), 4)));
	return fila;
}

function crearFilaMes(idCto, descripcion, idOri, nuevo, total, pagado, pendiente, pagar){	
	var input = $("<input type='text'/>").attr("idCto",idCto).attr("mes",descripcion).attr("idOri",idOri).attr("nuevo",nuevo).attr("readonly",false)
	                                     .val(formatCurrency(Number(unformatCurrency(pagar)), 4)).change(function() {	            
	            
	            if($(this).val() != "")
	            {
	            	var resultado = validaMonto($(this).val()); 
		            var res       = validarFilaMes($(this).attr("idCto"), $(this).attr("mes"),  $(this).val());	            
		            
		            if(!resultado.valido)
		            {
		            	showError(resultado.mensaje);
		            	 
		            	$(this).attr("valido", false);
		            }	             	            	
		            else if(!res)
		            {
		            	showError("El valor ingresado esta fuera de rango.");
		            	$(this).attr("valido", false);
		            }	            	
	                else 
	                {                	
	                	$(this).attr("valido", true);
			            actualizarFilaMes(idCto, descripcion, $(this).val())
					    sumarFilas("trMes"     , $(this).attr("idCto"), $(this).attr("mes"));
					    sumarFilas("trContrato", $(this).attr("idCto"), $(this).attr("mes"));
					    $(this).val( formatCurrency(Number(unformatCurrency($(this).val())), 4) );
	                }
		            formaValida = true;
	            }else $(this).val($(this).data('oldValue'));                         	 
	            
	}).focus(function() {
		$(this).data('oldValue', $(this).val());
		
	});
	
	var check = $("<input/>").attr("type","checkbox").attr("idCto",idCto).attr("mes",descripcion);	
	
	var fila = $("<tr/>").attr("id","idM"+"-"+idCto+"-"+descripcion).addClass("trMes accordion-body packageDetails"+idCto+" collapse in")
				.append($("<td/>"))
				.append($("<td/>").append("<ins>"+descripcion+"</ins>"))
				.append($("<td/>").text(formatCurrency(Number(unformatCurrency(total)), 4)))
				.append($("<td/>").text(formatCurrency(Number(unformatCurrency(pagado)), 4)))
				.append($("<td/>").text(formatCurrency(Number(unformatCurrency(pendiente)), 4)))
				.append($("<td class=''/>").append(check))
				.append($("<td/>").append(input));
	return fila;
}

function moverPendienteaPagar(idCto, mes){
	
	
	
	$("#tFacturaDetalle2 tr[id^=idM-"+idCto+"]").each(function(){
		
		
		
		if($(this).find("input[type='checkbox']").prop( "checked" ) )
		{
			

			var pendiente = parseFloat(unformatCurrency($(this).find("td:nth-child(5)").text()));
			var pagar     = parseFloat(unformatCurrency($(this).find("input[type='text']").val()));
			var valor     = formatCurrency(Number(unformatCurrency(pendiente+pagar)), 4);
			
			
			
			$(this).find("input[type='text']").val(valor);
			$(this).find("input[type='text']").attr("valido", "true");
			$(this).find("td:nth-child(5)").text("0");
		}		
	});
}

function actualizarFilaMes(idCto, mes, valor){			
	var total  = Number(unformatCurrency($("#tFacturaDetalle2 tr[id='idM-"+idCto+"-"+mes+"']").find("td:nth-child(3)").text()), 4);	
	var pagado = Number(unformatCurrency($("#tFacturaDetalle2 tr[id='idM-"+idCto+"-"+mes+"']").find("td:nth-child(4)").text()), 4);
	var pagar;
	
	for(var i=0; i< montosIniciales.length; i++)
		if(montosIniciales[i].id == (idCto+"-"+mes))		
			pagar =  montosIniciales[i].valor;			
	
	var res = total - (pagado);
	var pendiente = res - parseFloat(unformatCurrency(valor));				
	
	$("#tFacturaDetalle2 tr[id='idM-"+idCto+"-"+mes+"']").find("td:nth-child(5)").text(formatCurrency(Number(unformatCurrency(pendiente)), 4));		
}

function validarFilaMes(idCto, mes, valor){		
	var total     = Number(unformatCurrency($("#tFacturaDetalle2 tr[id='idM-"+idCto+"-"+mes+"']").find("td:nth-child(3)").text()), 4);	
	var pagado    = Number(unformatCurrency($("#tFacturaDetalle2 tr[id='idM-"+idCto+"-"+mes+"']").find("td:nth-child(4)").text()), 4);
	var pendiente = Number(unformatCurrency($("#tFacturaDetalle2 tr[id='idM-"+idCto+"-"+mes+"']").find("td:nth-child(5)").text()), 4);	
	var valido = false;
	valor      = parseFloat(unformatCurrency(valor));
	
	for(var i=0; i< montosIniciales.length; i++)
	{
		if(montosIniciales[i].id == (idCto+"-"+mes))
		{
			var resultado = total - (pagado - montosIniciales[i].valor);
			if(valor >= 0 && valor <= resultado)
				valido = true;
		} 	
	}		
	return valido;
}

function sumarFilas(clase, idCto, mes){		
	var valores = [0.0, 0.0, 0.0, 0.0];	
	var condicionOri = "";
	var condicionDes = "";
		
    if(clase == "trMes")
	{		
		condicionOri = "tr[id^=idM-"+idCto+"]";
		condicionDes = "tr[id=idC-"+idCto+"]";		
	}
	else if(clase == "trContrato")
	{
		condicionOri = "tr[id^=idC]";
		condicionDes = "monto";		
	}
	
	$("#tFacturaDetalle2 "+ condicionOri ).each(function(){		
		valores[0] = valores[0] + Number(unformatCurrency($(this).find("td:nth-child(3)").text()), 4);    		    	    		
		valores[1] = valores[1] + Number(unformatCurrency($(this).find("td:nth-child(4)").text()), 4);
		valores[2] = valores[2] + Number(unformatCurrency($(this).find("td:nth-child(5)").text()), 4);
		if(clase == "trContrato")
			valores[3] = valores[3] + Number(unformatCurrency($(this).find("td:nth-child(7)").text()), 4);
		else
			valores[3] = valores[3] + Number(unformatCurrency($(this).find("input:last").val()), 4);											
	});
					
	if(clase == "trMes")
	{					
		$("#tFacturaDetalle2 "+condicionDes).find("td:nth-child(3)").text(formatCurrency(Number(unformatCurrency(valores[0])), 4));    		    	    		
		$("#tFacturaDetalle2 "+condicionDes).find("td:nth-child(4)").text(formatCurrency(Number(unformatCurrency(valores[1])), 4));
		$("#tFacturaDetalle2 "+condicionDes).find("td:nth-child(5)").text(formatCurrency(Number(unformatCurrency(valores[2])), 4));
		$("#tFacturaDetalle2 "+condicionDes).find("td:nth-child(7)").text(formatCurrency(Number(unformatCurrency(valores[3])), 4));
	}		
	else if(clase == "trContrato")
	{
		$("#"+condicionDes).val(formatCurrency(Number(unformatCurrency(valores[3])), 4));
	}
}

function validaMonto(valor){
	var resultado =  {valido:true, mensaje: ""};
	valor = unformatCurrency(valor);
	
	if(isNaN(valor))
	{
		resultado.valido = false;
		resultado.mensaje = "El valor ingresado no es un n\u00FAmero.";
	}
	else if(parseFloat(valor) < 0)
	{
		resultado.valido = false;
		resultado.mensaje = "El valor ingresado debe ser mayor o igual a 0.";
	}
	return resultado;
}

function checkAtributo(attr){		
	if (typeof attr !== typeof undefined && attr !== false)
	     return true;
	else
		return false;
}