package com.mx.dla.dda.contrato.fees.daos;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.contrato.fees.dtos.CategoriaFeesDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesBonoRangoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesContratoPagoBD;
import com.mx.dla.dda.contrato.fees.dtos.FeesFlatBD;
import com.mx.dla.dda.contrato.fees.dtos.FeesPagoRangoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesSuscriptorBD;

public interface FeesContratoDAO {

	public List<FeesContratoPagoBD> getPeriodos(Long idContrato);
	
	//**Consultas para fees Suscriptor**	
	public List<FeesSuscriptorBD> getFeesSuscriptor  (@Param("idsContratoPago") List<Long> idsContratoPago);
	public void guardarPagoRango                     (@Param("rango")   FeesPagoRangoDTO rango, @Param("idContratoPago")Long idContratoPago);
	public void guardarPagoCostoALL                  (@Param("costos")  List<FeesSuscriptorBD> costos);
	public void guardarPagoCosto                     (@Param("idRango") Long idRango, @Param("costo")String costo, @Param("idCategoria")Long idCategoria);			
	public void eliminarPagoCosto                    (@Param("idCateg")        Long idCateg, @Param("idRango")Long idRango);
	public void eliminarPagoRango                    (@Param("idContratoPago") Long idContratoPago);
	public void eliminarContratoPago                 (@Param("idContratoPago") Long idContratoPago);
	public void eliminarPagoCostoXCto                (@Param("idCto")          Long idCto);
	public void eliminarPagoRangoXCto                (@Param("idCto")          Long idCto);
	public void eliminarPagoCostoXCategoria          (@Param("idCateg")        Long idCateg);
	
	//**Consultas para fees Flat**
	public List<FeesFlatBD>       getFeesFlat        (@Param("idsContratoPago") List<Long> idsContratoPago);
	public void guardarPagoFlatAll                   (@Param("flats")   List<FeesFlatBD>     flats);
	public void eliminarPagoFlat                     (@Param("idContratoPago") Long idContratoPago);
	public void eliminarPagoFlatxCto                 (@Param("idContrato")     Long idContrato);
	
	//**Consultas para fees bono**
	public List<FeesBonoRangoDTO> getRangosBono      (@Param("idContrato")  Long idContrato);
	public void guardarRangoBonoFlatALL              (@Param("rangos")List<FeesBonoRangoDTO> rangos, @Param("idContrato")Long idContrato);
	public void eliminarBono                         (@Param("idContrato") Long idContrato);
	public void eliminarRangoFlatBonoByRango         (@Param("idContrato") Long idContrato, @Param("idRango")Long idRango);
	
	//**Consultas para fees generales**
	public void actualizarContratoPago      (FeesContratoPagoBD pago);	
	public void guardarContratoPago         (FeesContratoPagoBD pago);
	public void eliminarContratoPagoXCto    (@Param("idContrato")     Long idContrato);
	public String getTipoFees               (Long idContrato);

	//**Consultas para fees categoria**
	public void guardarCategoria            (@Param("categ")   CategoriaFeesDTO categoria, @Param("idContrato")Long idContrato);
	public void actualizarCategoria         (@Param("categoria")   CategoriaFeesDTO categoria);
	public void eliminarCategoriasContrato  (@Param("idContrato")     Long idContrato);	
	public List<CategoriaFeesDTO> getCategoriasTitulosXContrato (@Param("idContrato")      Long idContrato);	
	public List<CategoriaFeesDTO> getCategoriasTitulosXCategoria(@Param("idCategoria")     Long idCategoria);
	public void eliminarPagoFlatByCategoria (@Param("idCateg")        Long idCateg);		
	public void actualizarTitulosTCateg     (@Param("idCategoria") Long idCategoria);
	public void actualizarTitulosMCateg     (@Param("idCategoria") Long idCategoria);
	public void eliminarPagoCategoria       (@Param("idCateg")        Long idCateg);
	
	//**Consultas para fees contrato**
	public String fechaInicio(Long idCto);
	public String fechaFin   (Long idCto);
	public void actualizarInflacionCto      (@Param("inflacion")String inflacion, @Param("idContrato")Long idContrato);

	public String actualizarCostoTitulos(Map<String, Object> paramNumeroContrato);

	public String getCostoTotal(@Param("idContrato")Long idContrato);
	
}
