package com.mx.dla.dda.contrato.ws.obtenersuscriptores;

import java.io.Serializable;

/**
 * Representa la respuesta que sera enviada al Front-End por parte de este componente al ejecutar el proceso de obtener Suscriptores Contrato.
 * Incluye un mensaje y resultado de la transaccion y el valor de los suscriptores acorde a las configuraciones del contrato
 *
 */
public class ResponseSuscriptoresContratoDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String mensaje;
	private boolean resultado;
	private String suscriptores;
	
	public String getMensaje() {
		return this.mensaje;
	}
	public void setMensaje(String mensaje) {
		this.mensaje = mensaje;
	}
	public boolean getResultado() {
		return resultado;
	}
	public void setResultado(boolean resultado) {
		this.resultado = resultado;
	}
	public String getSuscriptores() {
		return suscriptores;
	}
	public void setSuscriptores(String suscriptores) {
		this.suscriptores = suscriptores;
	}
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" mensaje: _" + this.getMensaje() + "_" + NEW_LINE);
		result.append(" resultado: _" + this.getResultado() + "_" + NEW_LINE);
		result.append(" suscriptores: _" + this.getSuscriptores() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
	
}
