package com.mx.dla.dda.excelMapper.exceptions;

import java.util.ArrayList;
import java.util.List;

public class ExcelMapperException extends Exception{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6058087215816293113L;

	public static final String ERROR_READING_FILE = "Error al leer el archivo: ";
	
	
    public static String ERROR_PARSING = "Error al interpretar el mapeo ";
    public static String ERROR_PARENT = "Error al buscar el mapeo padre  ";
    public static String ERROR_INIT_POPULATE = "Error al inicializar el bean ";
    public static String ERROR_SETTING_VAL = "Error al poner el valor [%s] en [%s] ";
    public static String ERROR_GETTING_VAL = "Error al obtener el valor en [%s] ";
    public static String ERROR_MAPPER = "Error al obtener el mapeo  ";
    public static String ERROR_MAPPER_CLASS = "Error al vincular el mapeo [%s] con [%s] ";
    public static String ERROR_MULTIPLE_MAPPER = "Multiples resultados para ";
    
    
    public static String ERROR_READING_EXCEL_FILE = "No existe clase para el mapeo ";

	List<String> errors;
	
	public ExcelMapperException(String message)
	{
		super(message);
		errors = new ArrayList<String>();
	}
	
	public ExcelMapperException(String message,Object ... args)
	{
		super(String.format(message, args));
		errors = new ArrayList<String>();
	}
	
	public ExcelMapperException(String message, List<String> errors)
	{
		super(message);
		this.errors = errors;
	}
	
	public ExcelMapperException( Throwable e,String message)
	{
		super(message,e);
		errors = new ArrayList<String>();
	}
	
	public ExcelMapperException( Throwable e,String message,Object ... args)
	{
		super(String.format(message, args),e);
		errors = new ArrayList<String>();
	}
	
	public ExcelMapperException(String message ,List<String> errors , Throwable e)
	{
		super(message,e);
		this.errors = errors;
	}
	
	public String getSErrors()
	{
		StringBuilder sb = new StringBuilder();
		for(String s : errors)
		{
			sb.append(s);
			sb.append(" | ");
		}
		return sb.toString();
	}
	
	public List<String> getErrors() {
		return errors;
	}
}
