package com.mx.dla.dda.general.utilerias;

import java.util.Collections;
import java.util.List;

public class ListaUtilerias {

	@SuppressWarnings("unchecked")
	public static <T> List<T> safeList(final List<T> other) {
		return other == null ? Collections.EMPTY_LIST : other;
	}
	
	@SuppressWarnings("unchecked")
	public static <T> T[] safeArray(final T[] other, Class<T> clazz) {
		return other == null ? (T[])java.lang.reflect.Array.newInstance(
				clazz, 1) : other;
	}
	
	@SuppressWarnings("unchecked")
	public static <T> T[][] safeArray(final T[][] other, Class<T> clazz, int dx, int dy) {
		return other == null ? (T[][])java.lang.reflect.Array.newInstance(clazz, dx, dy) : other;
	}

}
